'''
- dialog.py
- This file handles interfacing the dialog functions of VIDS
'''


# External imports

# Internal imports
from src.core.configuration.dialog_conf import *
import src.utils.dialog.intent as intent
import src.utils.dialog.chatbot.simple_chatbot as simple_chatbot
import src.utils.web.get_response as response


'''
----------run----------
- Given a user input and the currently-active configuration/techniques, generate the proper response
-----Inputs-----
- text - The user input to parse
- petel_exp - The current petel expression
- schema - The currently-active user database schema
- configuration - The currently-active configuration
- embedding - The loaded embedding
- ner - The loaded named entity recognition technique (Optional)
-----Output-----
- response - A key-value pair of both the text response and the associated PeTEL expression
'''
def run(text, petel_exp, schema, configuration, embedding, ner=None, debug=False, task='ner'):
    # Get the user's intent for the current statement
    intent = get_intent(text.lower())
    if(debug):
        print("Intent: ", intent)

    # Get the response from VIDS
    return response.run(text, petel_exp, schema, configuration, embedding, ner, debug=debug, task=task, intent=intent)
    # return get_chatbot_response(text.lower(), intent, petel_exp, schema, configuration, embedding, ner, debug)


'''
----------get_intent----------
- Given some user input, extract the intention and return it
-----Inputs-----
- text - The user input to parse
-----Output-----
- intent - The extracted intent for the given query
'''
def get_intent(text):
    if (False):
        pass
    else:
        return intent.simple_detection(text)


'''
----------get_chatbot_response----------
- Given some user input, run it through the proper chatbot and return its response
-----Inputs-----
- text - The user input to parse
- intent - The extracted user intent
- petel_exp - The current petel expression
- schema - The currently-active user database schema
- configuration - The currently-active configuration
- embedding - The loaded embedding
- ner - The loaded named entity recognition technique (Optional)
-----Output-----
- response - A key-value pair of both the text response and the associated PeTEL expression
'''
def get_chatbot_response(text, intent, petel_exp, schema, configuration, embedding, ner=None, debug=False):
    return simple_chatbot.get_response(text, intent, petel_exp, schema, configuration, embedding, ner, debug)
    # return response.get_chatbot_response(text)