'''
- similarity.py
- This file handles interfacing crucial similarity functions with the similarity utilities
'''

# External imports

# Internal imports
import src.utils.similarity.normalize as normalizer
import src.utils.similarity.cosine as cosine
import src.utils.similarity.euclidean as euclidean



'''
----------normalize----------
- This function normalizes the ranked list
-----Inputs-----
- ranking - the ranked list to normalize
- function - the normalization function to use (defaults to basic normalization)
-----Output-----
- normalized_ranking - the sorted, normalized version of the ranked list
'''
def normalize(ranking, function=""):
    if (function == "softmax"):
        return normalizer.softmax(ranking)
    else:
        return normalizer.basic_norm(ranking)


'''
----------rank_values----------
- This function ranks the given values based on the given embedding
-----Inputs-----
- text - the user input to parse
- features - the features to rank
- embedding - the dictionary of embeddings
- configuration - the currently-active configuration
-----Output-----
- rankings - the resultant ranked list of items
'''
def rank_values(text, features, embedding, configuration):
    if "cosine" in configuration["similarity_function"]:
        if "max-pull" in configuration["similarity_function"]:
            pass
        elif "windowed" in configuration["similarity_function"]:
            pass
        else:
            # Take the regular cosine distance
            return cosine.rank_by_cosine(text, features, embedding, configuration)
    elif "euclidean" in configuration["similarity_function"]:
        if "max-pull" in configuration["similarity_function"]:
            pass
        elif "windowed" in configuration["similarity_function"]:
            pass
        else:
            return euclidean.rank_by_euclidean(text, features, embedding, configuration)
    else:
        # If the similarity function isn't recognized, print that and leave the rankings untouched (return the original ranking)
        print("Similarity function not detected")
        return ranking