'''
- petel.py
- This file is meant to handle all of the PeTEL expression management for VIDS
'''


# External imports

# Internal imports
# import src.core.interface.ranking as ranking
# import src.core.interface.similarity as similarity

# Parameters
DEMOTION_WEIGHT = .05 # This is the weight of a feature's current probability distribution after demotion (wrong guess)



class petel:
    '''
    ----------Constructor----------
    - Initializes all necessary values of the class
    -----Inputs-----
    - schema - the schema to use for the PeTEL expression
    - json_exp - the json expression to initialize the PeTEL expression to
    -----Output-----
    - self - the initialized PeTEL object, bound to a variable
    '''
    def __init__(self):
        self.domains = {
                    "linear_regression":{
                        'prediction_attr': [{'key': 'FLIGHT_NUMBER', 'val': 0.25},
                                            {'key': 'ELAPSED_TIME', 'val': 0.25},
                                            {'key': 'DEPARTURE_DELAY', 'val': 0.25},
                                            {'key': 'ARRIVAL_DELAY', 'val': 0.25},],
                        'input_feature': [],
                        'filter_attr': [{'key': 'FLIGHT_NUMBER', 'val': 0.25},
                                            {'key': 'ELAPSED_TIME', 'val': 0.25},
                                            {'key': 'DEPARTURE_DELAY', 'val': 0.25},
                                            {'key': 'ARRIVAL_DELAY', 'val': 0.25},],
                        'filter_op': [{'key': 'gt', 'val': 0.2}, 
                                        {'key': 'lt', 'val': 0.2},
                                        {'key': 'equal', 'val': 0.2}, 
                                        {'key': 'not_equal', 'val': 0.2},
                                        {'key': 'like', 'val': 0.2}],
                        'agg_op': [{'key': 'sum', 'val': 0.33},
                                        {'key': 'avg', 'val': 0.33},
                                        {'key': 'mean', 'val': 0.33}],
                    },
                    "binary_classification":{
                        'prediction_attr': [{'key': 'FLIGHT_NUMBER', 'val': 0.25},
                                            {'key': 'ELAPSED_TIME', 'val': 0.25},
                                            {'key': 'DEPARTURE_DELAY', 'val': 0.25},
                                            {'key': 'ARRIVAL_DELAY', 'val': 0.25},],
                        'input_feature': [],
                        'filter_attr': [{'key': 'FLIGHT_NUMBER', 'val': 0.25},
                                            {'key': 'ELAPSED_TIME', 'val': 0.25},
                                            {'key': 'DEPARTURE_DELAY', 'val': 0.25},
                                            {'key': 'ARRIVAL_DELAY', 'val': 0.25},],
                        'filter_op': [{'key': 'gt', 'val': 0.2}, 
                                        {'key': 'lt', 'val': 0.2},
                                        {'key': 'equal', 'val': 0.2}, 
                                        {'key': 'not_equal', 'val': 0.2},
                                        {'key': 'like', 'val': 0.2}],
                        'agg_op': [{'key': 'sum', 'val': 0.33},
                                        {'key': 'avg', 'val': 0.33},
                                        {'key': 'mean', 'val': 0.33}],
                        'classifier': [],
                    }, 
                    "time_series": {
                        'prediction_attr': [],
                        'input_feature': [],
                        'filter_attr': [],
                        'filter_op': [],
                        'agg_op': [],
                        'splits': [],
                    }
                     }
        self.valid = False
        self.active_domain = "linear_regression"
        self.rankings = {"entity":[], "attribute":[]}#, "filters":[], "operations":[], "aggregators":[]}
    


    '''
    ----------update----------
    - Updates all ranked lists' distributions based on a new input
    -----Inputs-----
    - self - the PeTEL object to update (included intrinsically)
    - text - the user input to parse
    - schema - the currently-active user database schema
    - embedding - the currently-active embedding
    - configuration - the currently-active configuration
    -----Output-----
    - self - the bound PeTEL object's rankings' distributions are all updated based off the text and embedding
    '''
    def update(self, text, schema, embedding, configuration):
        i=0
        # for key in self.flags:
        #     self.rankings[key] = ranking.update_rankings(text, schema[key], self.rankings[key], embedding, configuration)
        # return

    
    '''
    ----------update_active----------
    - Updates the targeted ranked list's distribution based on a new input
    -----Inputs-----
    - self - the PeTEL object to update (included intrinsically)
    - text - the user input to parse
    - schema - the currently-active user database schema
    - embedding - the currently-active embedding
    - configuration - the currently-active configuration
    -----Output-----
    - self - the target ranking distribution of the bound PeTEL object is updated based off the text and embedding
    '''
    def update_active(self, text, schema, embedding, configuration):
        # This function will accept an additional confidence argument, and pass it along to the ranking function
        self.rankings[self.active_feature] = [] #ranking.update_joint_ranking(text, schema[self.active_feature], self.rankings[self.active_feature], embedding, configuration)
        # JOINT RANKING: To revert, comment out the above line, and uncomment the below line
        #self.rankings[self.active_feature] = ranking.update_rankings(text, schema[self.active_feature], self.rankings[self.active_feature], embedding, configuration)


    '''
    ----------demote_value----------
    - Lowers the target feature's probability, so it goes to the bottom of the list
    -----Inputs-----
    - self - the PeTEL object to update (included intrinsically)
    - index - the index of the value of the active feature to demote
    -----Output-----
    - self - the target value in the currently-active feature has a lowered probability in the distribution, pushing it to the bottom of the ranking
    '''
    def demote_value(self, index, normalization="softmax"):
        self.rankings[self.active_feature][index]["distribution"] = self.rankings[self.active_feature][index]["distribution"] * DEMOTION_WEIGHT
        # self.rankings[self.active_feature] = similarity.normalize(self.rankings[self.active_feature], normalization)


    '''
    ----------finished_feature----------
    - Description
    -----Inputs-----
    - input - description
    -----Output-----
    - output - description
    '''
    def finished_feature(self):# Can probably be streamlined
        counter = 0
        for key in self.flags:
            if key == self.active_feature and not self.flags[key]:
                self.flags[key] = True
                counter += 1
            if (counter > 0):
                self.active_feature = key
        return


    '''
    ----------is_complete----------
    - Description
    -----Inputs-----
    - input - description
    -----Output-----
    - output - description
    '''
    def is_complete(self):
        for key in self.flags:
            if not self.flags[key]:
                return False
        return True