'''
- dialogflow.py
- This file handles text annotation using dialogflow
'''

# External imports
import dialogflow_v2 as dialogflow
import time

# Internal imports
from src.core.configuration.annotation_conf import *



'''
----------load_model----------
- Loads dialogflow for later use in VIDS
-----Inputs-----
- N/A
-----Output-----
- loaded_model - The loaded session-client for Dialogflow
'''
def load_model():
    return {'session-client':dialogflow.SessionsClient.from_service_account_json(DIALOGFLOW_LOC)}


'''
----------annotate----------
- Uses Dialogflow to properly annotate the input text
-----Inputs-----
- text - The user input to parse
- schema - The currently-active user database schema
- active_feature - The currently-active feature in the PeTEL expression
- ner - The loaded named entity recognition technique
-----Output-----
- entity_detection_text - The annotated text as detected by Dialogflow
'''
def annotate(text, schema, active_feature, ner):
    entity_detection_text = ""
    result = detect_intent_texts([text], ner["session-client"])
    context_count = len(result.output_contexts)
    context_fields = result.output_contexts[context_count - 1].parameters.fields
    for feature in schema[active_feature]:
        if (len(context_fields[feature['name']].list_value.values) > 0):
            detected_entity = feature['name']
            entity_detection_text = context_fields[feature['name']].list_value.values[0].string_value
    print(entity_detection_text)
    return {"text":entity_detection_text,"confidence":1}
    # JOINT RANKING: To revert, comment out the above line, and uncomment the below line
    #return entity_detection_text


'''
----------detect_intent_texts----------
- Returns the result of "detect intent" with texts as inputs.
-----Inputs-----
- texts - The user input to parse
- sesion_client - The already-loaded session client
-----Output-----
- output - description
'''
def detect_intent_texts(texts, session_client):
    # Temporary rate-limiter to meet the queries-per-minute quota
    time.sleep(.5)

    session = session_client.session_path(DIALOGFLOW_PROJECT_ID, DIALOGFLOW_SESSION_ID)

    for text in texts:
        text_input = dialogflow.types.TextInput(text=text, language_code=DIALOGFLOW_LANGUAGE_CODE)

        query_input = dialogflow.types.QueryInput(text=text_input)

        response = session_client.detect_intent(session=session, query_input=query_input)
        print('Response: {}\n'.format(response.query_result.fulfillment_text))

        return response.query_result