'''
- simple_chatbot.py
- This file handles user interaction for VIDS
'''


# External imports
from cgi import print_environ
from pyexpat import features
import numpy as np
import os


# Internal imports
from src.core.configuration import chatbot_conf
from src.core.interface import annotation, ranking
import src.utils.misc.directory_ops as directory



'''
----------get_response----------
- Given some user input, run it through the proper chatbot and return its response
-----Inputs-----
- text - The user input to parse
- intent - The extracted user intent
- petel_exp - The current petel expression
- schema - The currently-active user database schema
- configuration - The currently-active configuration
- embedding - The loaded embedding
- ner - The loaded named entity recognition technique (Optional)
-----Output-----
- response - A key-value pair of both the text response and the associated PeTEL expression
'''
# def get_response(text, intent, petel_exp, schema, configuration, embedding, ner=None, debug=False):

   
#     response = ''
#     if (intent == "query"):
#         # Clean the user input
#         text = annotation.cleanse_input(text)

#         active_feature = petel_exp.active_feature
#         for feature in petel_exp.flags:
#             passalong_text = []
#             # JOINT RANKING: To revert, comment out the above line and uncomment the below line
#             #passalong_text = ""
#             # Set the PeTEL expression's active feature
#             petel_exp.active_feature = feature

#             # Annotate the user input based on the current NER technique
#             ner_confidence = 1# Set the default value to 1?
#             if (ner):
#                 # Change the next line to return [{"text":str,"confidence":float}] and assign from there
#                 temp_text = annotation.annotate_text(text, feature, configuration["ner"], ner, debug=False)
#                 if debug:
#                     print("\nFeature:", feature, "==> annotated text:", temp_text)
#                 if not temp_text:
#                     temp_text = [{"text":text,"confidence":1}, {"text":"None","confidence":1}]

#                 # This verification should loop over all possible sub-phrases, and allow it through if one works
#                 ner_valid = False
#                 # JOINT RANKING: To revert, set the below variable to 'False'
#                 using_joint_ranking = True
#                 if using_joint_ranking:
#                     for phrase in temp_text:
#                         phrase_embedding = ranking.get_avg_text_embedding(phrase["text"], embedding, configuration)
#                         phrase_length = len(annotation.cleanse_input(phrase["text"], True).split())
#                         if (np.count_nonzero(phrase_embedding) > 0) and (phrase_length >= 1):
#                             ner_valid = True
#                             #print("NER annotation {} is useful".format(temp_text))
#                     # If any one phrase is valid, keep them all, b/c the joint ranking should implicitly disqualify the bad ones
#                     if ner_valid:
#                         passalong_text = temp_text
#                     else:
#                         #passalong_text = [{"text":text,"confidence":1}]
#                         pass
#                 else:
#                     text_embedding = ranking.get_avg_text_embedding(temp_text, embedding, configuration)
#                     phrase_length = len(annotation.cleanse_input(temp_text, True).split())
#                     if (np.count_nonzero(text_embedding) > 0) and (phrase_length >= 1):
#                         passalong_text = temp_text
#                     else:
#                         passalong_text = text
#                 #print(feature, " ~ " ,text)
#             else:
#                 passalong_text = [{"text":text,"confidence":1}]
#                 # JOINT RANKING: To revert, comment out the above line and uncomment the below line
#                 #pass

#             # print("Pass along text", passalong_text)
#             petel_exp.update_active(passalong_text, schema, embedding, configuration)# Make this function accept an ner_confidence argument
#         # Reset the PeTEL expression's active feature to what it was originally
#         petel_exp.active_feature = active_feature

#         # Generate the response
#         response = 'Thank you! It looks like the target ' + active_feature +\
#             ' of your goal prediction task is ' + petel_exp.rankings[active_feature][0]['name'] +\
#             ', is that correct?'
#     elif (intent == "yes" and petel_exp.is_complete()):
#         # Mark the expression as valid
#         petel_exp.valid = True
#         response = 'Fantastic! Thanks for talking it through with me!'
#     elif (intent == "yes"):
#         # Mark the current active feature as 'done'
#         petel_exp.finished_feature()

#         # Generate the response
#         response = 'Thanks for confirming!\n'
#         active_feature = petel_exp.active_feature
#         if not petel_exp.is_complete():
#             response += 'Great! So now, let\'s focus on the target ' + active_feature + ' of your goal prediction task.' +\
#                 ' It looks like you are interested in predicting for the ' + active_feature + ' ' + \
#                 petel_exp.rankings[active_feature][0]['name'] + ', is that correct?'
#         else:
#             response += 'So this is the problem you are trying to solve:\nPredict the '
#             for rank in petel_exp.rankings:
#                 response += rank + ': ' + petel_exp.rankings[rank][0]['name'] + ' \n'
#                 # + ' for each ' +\
#                 # petel_exp.rankings['filter'][0]['name'] + 
#             response += '. Is that correct?'
#     elif (intent == "no"):
#         # Mark the current suggestion as false, and suggest the next item in the list
#         petel_exp.demote_value(0)

#         # Clean the user input
#         # text = annotation.cleanse_input(text)

#         # # Try to annotate the new statement
#         # annotated_text = text
#         # passalong_text = [{"text":text,"confidence":1}]
#         # ner_valid = False
#         # if (ner and text != "no"):
#         #     annotated_text = annotation.annotate_text(text, petel_exp.active_feature, configuration["ner"], ner)
#         #     if not annotated_text:
#         #         annotated_text = [{"text":text,"confidence":1}]
#         #     # print(annotated_text)
#         #     for phrase in annotated_text:
#         #         phrase_embedding = ranking.get_avg_text_embedding(phrase["text"], embedding, configuration)
#         #         phrase_length = len(annotation.cleanse_input(phrase["text"], True).split())
#         #         if (np.count_nonzero(phrase_embedding) > 0) and (phrase_length >= 1):
#         #             ner_valid = True
#         #             #print("NER annotation {} is useful".format(temp_text))
#         #     # If any one phrase is valid, keep them all, b/c the joint ranking should implicitly disqualify the bad ones
#         #     if ner_valid:
#         #         passalong_text = annotated_text
#         #     petel_exp.update_active(passalong_text, schema, embedding, configuration)# Make this function accept an ner_confidence argument
        
#         #     # pass

#         # # If the annotated query matches the original query, it wasn't annotated properly, and therefore wasn't useful
#         # if (text != annotated_text):
#         #     # Update the distribution with the new information
#         #     pass
        
#         # Generate the response
#         response = 'Okay, so then is the target ' + petel_exp.active_feature + ' of your goal prediction task the ' + \
#             petel_exp.rankings[petel_exp.active_feature][0]['name'] + '?'

#     elif (intent == "welcome"):
#         # Output the welcome message
#         response = 'Welcome to VIDS, I am your Virtual Data Science Assistant! I\'m here to help you with your prediction needs and goals! ' +\
#         'Just tell me in plain English what prediction task you want to solve. For example, you can ask me questions like: ' +\
#         '"I want to predict the average delay for each origin airport over the next week."'

#     elif (intent == "list"):
#         # Output the current ranking
#         print("----------Current {} ranking----------".format(petel_exp.active_feature))
#         counter = 1
#         for item in petel_exp.rankings[petel_exp.active_feature]:
#             if counter < 10:
#                 print("0{}. {} - {}".format(counter, item["name"], item["distribution"]))
#             else:
#                 print("{}. {} - {}".format(counter, item["name"], item["distribution"]))
#             counter+=1
    
#     # Return the response and the PeTEL expression

#     return {"expression": petel_exp, "response":response}



def get_response_with_annotation(text, annotation, intent, petel_exp, schema, configuration, embedding, ner=None, debug=False):
    response = ""
    if debug:
        print(intent)
        print("counter:", petel_exp.counter)
    if not petel_exp.is_complete():
        if petel_exp.flags[petel_exp.active_feature]['completed']:
            petel_exp.finished_feature()
    if debug:
        print(petel_exp.active_feature)

    eval_data_path = chatbot_conf.HUMAN_EVAL_DATA_LOC + schema['name']
    # Based on the intent, perform an action
    if not (os.path.exists(eval_data_path)):
        directory.create(eval_data_path)
        eval_file = open(eval_data_path + "/eval.txt", 'w')
    else:
        eval_file = open(eval_data_path + "/eval.txt", 'a')
    
    

    if (intent == "query"):
        active_feature = petel_exp.active_feature
        eval_file.write("[\n")
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
   
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        for feature in petel_exp.flags:
            passalong_text = []
            # JOINT RANKING: To revert, comment out the above line and uncomment the below line
            #passalong_text = ""
            # Set the PeTEL expression's active feature
            petel_exp.active_feature = feature

            # Annotate the user input based on the current NER technique
            ner_confidence = 1.0# Set the default value to 1?
            SMALL_NUM = 1e-4
            if (ner):
                # Change the next line to return [{"text":str,"confidence":float}] and assign from there
                annotated_text = annotation[feature]
                if debug:
                    print("Feature:", feature, "==> annotated text:", annotated_text)
                if not annotated_text:
                    annotated_text = [{"text":"None", "confidence": ner_confidence}]
                    rankings = petel_exp.rankings[feature]
                    updated_ranking = []
                    for rank in rankings:
                        name = rank['name']
                        if name == 'NONE':
                            distribution = 0
                        else:
                            distribution = SMALL_NUM
                        updated_ranking.append({'name': name, 'distribution': distribution})

                    rankings = updated_ranking
                    rankings = sorted(rankings, key=lambda i: i["distribution"], reverse=False)
                    petel_exp.rankings[feature] = rankings
                    continue

                # This verification should loop over all possible sub-phrases, and allow it through if one works
                ner_valid = False
                # JOINT RANKING: To revert, set the below variable to 'False'
                using_joint_ranking = True
                if using_joint_ranking:
                    for phrase in annotated_text:
                        phrase_embedding = ranking.get_avg_text_embedding(phrase["text"], embedding, configuration)
                        phrase_length = len(phrase["text"].split())
                        if (np.count_nonzero(phrase_embedding) > 0) and (phrase_length >= 1):
                            ner_valid = True
                            #print("NER annotation {} is useful".format(annotated_text))
                    # If any one phrase is valid, keep them all, b/c the joint ranking should implicitly disqualify the bad ones
                    if ner_valid:
                        passalong_text = annotated_text
                    else:
                        #passalong_text = [{"text":text,"confidence":1}]
                        pass
                else:
                    text_embedding = ranking.get_avg_text_embedding(annotated_text, embedding, configuration)
                    phrase_length = len(annotated_text.split())
                    if (np.count_nonzero(text_embedding) > 0) and (phrase_length >= 1):
                        passalong_text = annotated_text
                    else:
                        passalong_text = text
                #print(feature, " ~ " ,text)
            else:
                passalong_text = [{"text":text,  "confidence":1}]
                # JOINT RANKING: To revert, comment out the above line and uncomment the below line
                #pass
            if debug:
                print(passalong_text)
            petel_exp.update_active(passalong_text, schema, embedding, configuration)# Make this function accept an ner_confidence argument
            #remove break
            
        # Reset the PeTEL expression's active feature to what it was originally
        petel_exp.active_feature = active_feature
        # petel_exp.counter += 1
        # petel_exp.flags[active_feature]['count'] += 1

        # Generate the response
        response = 'Thank you! It looks like the ' + active_feature +\
            ' of your goal prediction task is ' + petel_exp.rankings[active_feature][0]['name'] +\
            ', is that correct?'
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    elif (intent == "yes_wo_info" and petel_exp.is_complete()):
        # Mark the expression as valid
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
   
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        eval_file.write("\tActive Feature: {}\n".format(petel_exp.active_feature))
        petel_exp.valid = True
        response = 'Fantastic! Thanks for talking it through with me! Total interaction count is {}'.format(petel_exp.counter)
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("}\n")
        eval_file.write("]\n")
    elif (intent == "yes_wo_info"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        # Mark the current active feature as 'done'
        active_feature = petel_exp.active_feature
        petel_exp.counter += 1
        petel_exp.flags[active_feature]['count'] += 1
        petel_exp.finished_feature()
        active_feature = petel_exp.active_feature

        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        # Generate the response
        response = 'Thanks for confirming!'
        
        if not petel_exp.is_complete():
            response += 'Let\'s focus on the {} of your goal prediction task. It looks like for the {} you want to use {}, is that correct?'.format(active_feature, active_feature, petel_exp.rankings[active_feature][0]['name'])
        else:
            response += 'So this is the problem you are trying to solve:\nPredict the '
            for rank in petel_exp.rankings:
                response += rank + ': ' + petel_exp.rankings[rank][0]['name'] + ' \n'
                # + ' for each ' +\
                # petel_exp.rankings['filter'][0]['name'] + 
            response += '. Is that correct?'
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    elif (intent == "yes_w_info"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        
        #  Mark the current active feature as 'done'
        active_feature = petel_exp.active_feature
        petel_exp.counter += 1
        petel_exp.flags[active_feature]['count'] += 1
        petel_exp.finished_feature()
        active_feature = petel_exp.active_feature
        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        # Generate the response
        response = 'Thanks for confirming! '
        
        if petel_exp.is_complete():
            response += 'So this is the problem you are trying to solve:\nPredict the '
            for rank in petel_exp.rankings:
                response += rank + ': ' + petel_exp.rankings[rank][0]['name'] + ' \n'
                # + ' for each ' +\
                # petel_exp.rankings['filter'][0]['name'] + 
            response += '. Is that correct?'
            
        else:
            petel_exp = update_petel_with_info(petel_exp, ner, text, annotation, embedding, schema, configuration)
            response += 'Let\'s focus on the {} of your goal prediction task. It looks like for the {} you want to use {}, is that correct?'.format(active_feature, active_feature, petel_exp.rankings[active_feature][0]['name'])
        
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")

    elif (intent == "no_w_info"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        
        active_feature = petel_exp.active_feature
        petel_exp.counter += 1
        petel_exp.flags[active_feature]['count'] += 1
        petel_exp.demote_value(0)
        # Mark the expression as valid
        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        petel_exp = update_petel_with_info(petel_exp, ner, text, annotation, embedding, schema, configuration)
         # Generate the response
        response +=  petel_exp.active_feature + ' of your goal prediction task the ' + \
                    petel_exp.rankings[petel_exp.active_feature][0]['name'] + '?'

        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    elif (intent == "no_wo_info"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        
        active_feature = petel_exp.active_feature
        petel_exp.counter += 1
        petel_exp.flags[active_feature]['count'] += 1
        # Mark the current suggestion as false, and suggest the next item in the list
        petel_exp.demote_value(0)
        
        response = 'Okay, so then is the '
        # for pflag in petel_exp.flags:
        if not petel_exp.flags[active_feature]['completed']:
            # petel_exp.active_feature = pflag
            # petel_exp.demote_value(0)
            # Try to annotate the new statement
            # passalong_text = [{"text":text,"confidence":1}]
            # petel_exp.update_active(passalong_text, schema, embedding, configuration)# Make this function accept an ner_confidence argument
    
            # Generate the response
            response +=  petel_exp.active_feature + ' of your goal prediction task should be ' + \
                petel_exp.rankings[petel_exp.active_feature][0]['name'] + '?'
        petel_exp.active_feature = active_feature
        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    elif (intent == "info"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        
        active_feature = petel_exp.active_feature
        petel_exp.counter += 1
        petel_exp.flags[active_feature]['count'] += 1
        # Mark the expression as valid
        petel_exp = update_petel_with_info(petel_exp, ner, text, annotation, embedding, schema, configuration)
         # Generate the response
        response +=  petel_exp.active_feature + ' of your goal prediction task is ' + \
                    petel_exp.rankings[petel_exp.active_feature][0]['name'] + ', am I correct?'
        
        eval_file.write("\tActive Feature: {}\n".format(active_feature))
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    elif (intent == "welcome"):
        # Output the welcome message
        response = 'Welcome to VIDS, I am your Virtual Data Science Assistant! I\'m here to help you with your prediction needs and goals! ' +\
        'Just tell me in plain English what prediction task you want to solve. For example, you can ask me questions like: ' +\
        '"I want to predict the average delay for each origin airport over the next week."'

    elif (intent == "list"):
        # Output the current ranking
        print("----------Current {} ranking----------".format(petel_exp.active_feature))
        counter = 1
        for item in petel_exp.rankings[petel_exp.active_feature]:
            if counter < 10:
                print("0{}. {} - {}".format(counter, item["name"], item["distribution"]))
            else:
                print("{}. {} - {}".format(counter, item["name"], item["distribution"]))
            counter+=1
    elif (intent == "undetermined"):
        eval_file.write("{\n")
        eval_file.write("\tUser: {}\n".format(text))
   
        eval_file.write("\tExtracted Intent: {}\n".format(intent))
        eval_file.write("\tAnnotation of NER: {}\n".format(annotation))
        eval_file.write("\tActive Feature: {}\n".format(petel_exp.active_feature))
        
        response = 'Thanks for confirming! Your input has been saved in the system.\n'
        response +=  petel_exp.active_feature + ' of your goal prediction task is ' + \
                petel_exp.rankings[petel_exp.active_feature][0]['name'] + ', am I correct?'
        
        eval_file.write("\tCurrent PeTEL Expression: {}\n".format(petel_exp.flags))
        eval_file.write("\tSystem: {}\n".format(response))
        eval_file.write("},\n")
    # Return the response and the PeTEL expression

    return {"expression": petel_exp, "response":response}

def update_petel_with_info(petel_exp, ner, text, annotation, embedding, schema, configuration):
    active_feature = petel_exp.active_feature
    for feature in petel_exp.flags:
        if not petel_exp.flags[feature]['completed']:
            passalong_text = []
            # JOINT RANKING: To revert, comment out the above line and uncomment the below line
            #passalong_text = ""
            # Set the PeTEL expression's active feature
            petel_exp.active_feature = feature

            # Annotate the user input based on the current NER technique
            ner_confidence = 1.0# Set the default value to 1?
            SMALL_NUM = 1e-4
            if (ner):
                # Change the next line to return [{"text":str,"confidence":float}] and assign from there
                annotated_text = annotation[feature]

                # print("Feature:", feature, "==> annotated text:", annotated_text)
                if not annotated_text:
                    annotated_text = [{"text": text, "confidence": ner_confidence}] #change into annotated text after training and see result
                    # rankings = petel_exp.rankings[feature]
                    # updated_ranking = []
                    # for rank in rankings:
                    #     name = rank['name']
                    #     if name == 'NONE':
                    #         distribution = 0
                    #     else:
                    #         distribution = SMALL_NUM
                    #     updated_ranking.append({'name': name, 'distribution': distribution})

                    # rankings = updated_ranking
                    # rankings = sorted(rankings, key=lambda i: i["distribution"], reverse=False)
                    # petel_exp.rankings[feature] = rankings
                    # continue

                # This verification should loop over all possible sub-phrases, and allow it through if one works
                ner_valid = False
                # JOINT RANKING: To revert, set the below variable to 'False'
                using_joint_ranking = True
                if using_joint_ranking:
                    for phrase in annotated_text:
                        phrase_embedding = ranking.get_avg_text_embedding(phrase["text"], embedding, configuration)
                        phrase_length = len(phrase["text"].split())
                        if (np.count_nonzero(phrase_embedding) > 0) and (phrase_length >= 1):
                            ner_valid = True
                            #print("NER annotation {} is useful".format(annotated_text))
                    # If any one phrase is valid, keep them all, b/c the joint ranking should implicitly disqualify the bad ones
                    if ner_valid:
                        passalong_text = annotated_text
                    else:
                        #passalong_text = [{"text":text,"confidence":1}]
                        pass
                else:
                    text_embedding = ranking.get_avg_text_embedding(annotated_text, embedding, configuration)
                    phrase_length = len(annotated_text.split())
                    if (np.count_nonzero(text_embedding) > 0) and (phrase_length >= 1):
                        passalong_text = annotated_text
                    else:
                        passalong_text = text
                #print(feature, " ~ " ,text)
            else:
                passalong_text = [{"text":text,  "confidence":1}]
                # JOINT RANKING: To revert, comment out the above line and uncomment the below line
                #pass
            petel_exp.update_active(passalong_text, schema, embedding, configuration)# Make this function accept an ner_confidence argument
    # Reset the PeTEL expression's active feature to what it was originally
    petel_exp.active_feature = active_feature
    return petel_exp