'''
- schema.py
- This file is meant to handle all of the schema file input operations
'''
import random
from src.core.configuration.datagen_conf import *
import json

from src.utils.misc.io import print_dict


'''
----------load----------
- Reads in a schema file, and returns a dictionary of feature lists
'''
def load_schema(file, name='online_delivary'):
    # Prep the file
    file = file.replace("\r", "")
    lines = file.split("\n")
    # Prep the categories list and counter
    categories = ["attribute", "entity"]
    counter = -1
    CONF_LOC = "src/core/evaluation/global_config.json"
    # Prep the return variable and temporary list variable
    schema = {}
    # with open(CONF_LOC) as global_config:
    #     global_configuration = json.load(global_config)
    #     SCHEMA_NAMES = global_configuration["schema"]
    
    schema['name'] = name
    temp_list = []
    # Iterate over each line of the file, sorting it
    for line in lines:
        if counter >= len(categories):
            break
        elif "---" in line:
            if counter >= 0:
                schema[categories[counter]] = temp_list
                temp_list = []
            counter += 1
        elif ('|' in line) and not (line == ""):
            features = line.split('|')
            temp_dict = {}
            if counter == 0 and len(features) == 3:
                # Append each new attribute
                temp_dict = {"name":features[0], "type":features[1], "description":features[2]}
                temp_list.append(temp_dict)
            elif counter == 1 and len(features) == 2:
                # Append each new entity
                temp_dict = {"name":features[0], "description":features[1]}
                temp_list.append(temp_dict)
    random.shuffle(temp_list)
    schema[categories[counter]] = temp_list
    file = open(STATIC_ATTR_LOC, 'r', encoding="utf8", newline="\n")
    static_attributes = json.loads(file.read())
    file.close()

    schema["filter"] = schema["attribute"]
    # schema["attribute"].append({"name":"NONE", "description": ""})
    schema["filter"].append({"name":"NONE", "description": ""})
    for attribute_name in static_attributes:
        attr_list = static_attributes[attribute_name]
        random.shuffle(attr_list)
        schema[attribute_name] = []
        schema[attribute_name].append({"name":"NONE", "description": ""})
        for attr in attr_list:
            schema[attribute_name].append({"name":attr.upper(), "description": ""})

    return schema