'''
- normalize.py
- This file handles various methods of normalizing the ranked list of values for each feature
'''

# External imports
import math

# Internal imports



'''
----------basic_norm----------
- This function normalizes the ranked list using basic vector normalization so it is easier to work with
-----Inputs-----
- ranking - the ranked list to normalize (a key-value pair: {"name":str, "distribution":number})
-----Output-----
- normalized_ranking - the sorted ranked list, normalized so all values add up to 1
'''
def basic_norm(ranking):
    maximum = -1
    for value in ranking:
        if (value["distribution"] > maximum):
            maximum = value["distribution"]
    # Reduce all the values so the maximum has a value of 1
    for value in ranking:
        value["distribution"] = value["distribution"] / maximum
    return sorted(ranking, key=lambda i: i["distribution"], reverse=True)


'''
----------softmax----------
- This function normalizes the ranked list using the softmax function so it is easier to work with
-----Inputs-----
- ranking - the ranked list to normalize (a key-value pair: {"name":str, "distribution":number})
-----Output-----
- normalized_ranking - the sorted ranked list, normalized so all values add up to 1
'''
def softmax(ranking):
    value_sum = 0.0
    for value in ranking:
        value_sum += math.exp(value["distribution"])
    # Iterate over the ranking, updating each one with the sum
    for value in ranking:
        value["distribution"] = math.exp(value["distribution"])/value_sum
    return sorted(ranking, key=lambda i: i["distribution"], reverse=True)