'''
- load_schema.py
- This file is meant to handle all of the schema file input operations
'''



'''
----------load_schema----------
- Reads in a schema file, and returns a dictionary of feature lists
'''
def load_schema(file):
    # Prep the file
    file = file.replace("\r", "")
    lines = file.split("\n")
    # Prep the categories list and counter
    categories = ["attribute", "entity"]
    counter = -1
    # Prep the return variable and temporary list variable
    schema = {}
    temp_list = []
    # Iterate over each line of the file, sorting it
    for line in lines:
        if counter >= len(categories):
            break
        elif "---" in line:
            if counter >= 0:
                schema[categories[counter]] = temp_list
                temp_list = []
            counter += 1
        elif ('|' in line) and not (line == ""):
            features = line.split('|')
            temp_dict = {}
            if counter == 0 and len(features) == 3:
                # Append each new attribute
                temp_dict = {"name":features[0], "type":features[1], "description":features[2]}
                temp_list.append(temp_dict)
            elif counter == 1 and len(features) == 2:
                # Append each new entity
                temp_dict = {"name":features[0], "description":features[1]}
                temp_list.append(temp_dict)
    schema[categories[counter]] = temp_list
    return schema