'''
Reads attribute and entity list, returns list of entities and list of attributes.
Different than the source code used in main code, this is used to create tables
for the website.
'''
def web_list_parser(file):
    file = file.replace("\r", "")
    f = file.split("\n")
    attribute_list = []
    entity_list = []
    i = 0
    while i < len(f):
        if "Attribute" in f[i]:
            while i < len(f) - 1:
                i += 1
                cur = f[i]
                if "---" in cur or cur == "":
                    continue
                if '|' not in cur:
                    break
                attrs = cur.split('|')
                if len(attrs) != 3:
                    err = "Attributes should have exactly 3 columns. "
                    err += "Error in line with containing: " + cur
                    raise ValueError(err)
                attribute_list.append((attrs[0], attrs[1], attrs[2]))
        if "Entities" in f[i]:
            while i < len(f) - 1:
                i += 1
                cur = f[i]
                if "---" in cur or cur == "":
                    continue
                if '|' not in cur:
                    break
                attrs = cur.split('|')
                if len(attrs) != 2:
                    err = "Entities should have exactly 2 columns. "
                    err += "Error in line with containing: " + cur
                    raise ValueError(err)
                entity_list.append((attrs[0], attrs[1]))
        i += 1

    if len(attribute_list) == 0:
        raise ValueError("No Attributes detected")
    if len(entity_list) == 0:
        raise ValueError("No Entities detected")

    return attribute_list, entity_list


"""
Temporary functions in place of updating attrs and ents later.
"""
def getEntities(msg):
    #entList = ["abc", "qrt", "pop", "asdkjf", "jkl", "zxc", "abcd-efg-jk"]
    #return random.choices(entList, k=3)

    confidence = msg.split(',')[1]
    entList = msg.split(',')[0].split(' entered ')[1].split(' as ')
    del entList[1]
    del entList[1]
    for x in range(0,len(entList)):
        entList[x] += '-' + confidence
    return entList

def getAttributes(msg):
    #return getEntities()
    confidence = msg.split(',')[1]
    attrList = msg.split(',')[0].split(' and ')
    del attrList[0]
    attrList[len(attrList)-1] = attrList[len(attrList)-1].split(' as ')[0]
    for x in range(0,len(attrList)):
        attrList[x] += '-' + confidence
    return attrList
