import imp
from flask import Flask, render_template, request
from src.core.interface.annotation import load_ner_model
from src.utils.misc.schema import *
#from src.utils.web.vector_rankings import *
from src.utils.web.get_response import *
from src.core.petel.petel import *
from src.utils.dialog.intent import *
from src.utils.dialog.chatbot.simple_chatbot import *
from src.utils.web.get_response import *
from src.core.interface import *
from src.core.interface import ranking, annotation
import json

app = Flask(__name__)
app.config.from_pyfile('configuration/config.py')

ALLOWED_EXTENSIONS = {'txt'}

# Temporary global variables in place of selections via the UI
#NER_ALGORITHM = ""
embedding = None
loaded_ner = None
configuration = {
    "model":"xlnet",
    "embedding":"glove",
    "similarity_function":"cosine",
    "schema":"flight_delay"
}

@app.route("/")
def index():
    return render_template("Home.html")


@app.route("/About")
def about():
    return render_template("Home.html")

    
@app.route("/Chat", methods=["POST", "GET"])
def chat():
    if request.method == 'POST':
        # check if the post request has the file part
        if 'SchemaFile' not in request.files:
            return render_template("Error.html", error="No file uploaded")
        file = request.files['SchemaFile']
        # if user does not select file, browser also
        # submit an empty part without filename
        if file.filename == '':
            return render_template("Error.html", error="No file uploaded")
        if file and allowed_file(file.filename):
            try:
                text = file.stream.read()
                file.close()
                text = text.decode("utf-8")
                schema = load_schema(text)
                return render_template("Chat.html", attrs=schema['attribute'], ents=schema['entity'], schema=schema)
            except ValueError as e:
                print(e)
                return render_template("Error.html", error=e)
        else:
            return render_template("Error.html", error="File must be in .txt format")
    else:
        return render_template("FileLoad.html")


@app.route("/FileLoad")
def fileLoad():
    try:
        file = open(app.root_path + "/static/data/FlightDelay.txt", 'r')
        text = file.read()
        file.close()
        schema = load_schema(text)
        return render_template("FileLoad.html", attrs=schema['attribute'], ents=schema['entity'])
    except ValueError as e:
        print(e)
        return render_template("Error.html", error=e)

    print(attribute_list)
    print()
    print(entity_list)


@app.route("/Tutorial")
def tutorial():
    return render_template("Tutorial.html")


@app.route("/ranks")
def ranks():
    text = request.args.get('text')
    features = json.loads(request.args.get('features'))
    return json.dumps(get_rankings(text, features))


@app.route("/intents")
def intents():
    text = request.args.get('text')
    return get_intents(text)


@app.route("/dialog", methods=['POST'])
def dialog():
    data = request.form
    text = data['text']
    expression = json.loads(data['expression'])
    schema = json.loads(data['schema'])
    if expression is None:
        embedding = ranking.load_embedding(configuration["embedding"])
        loaded_ner = annotation.load_ner_model(configuration["model"])
        schema_file = open('src/data/test_data/flight_delay' + '.schema', "r")
        schema = load_schema(schema_file.read())
        petel_exp = petel(schema=schema)
    else:
        petel_exp = petel(schema, expression)
    result = run(text, petel_exp, schema, configuration, embedding, loaded_ner)
    print(result['expression'].counter)
    return json.dumps({
            "expression":{"flags":result['expression'].flags,
            "valid":result['expression'].valid,
            "active_feature":result['expression'].active_feature,
            "rankings":result['expression'].rankings,
            "counter": result['expression'].counter
            }, 
            "response":result["response"]
            
        })


def allowed_file(filename):
    return '.' in filename and \
           filename.rsplit('.', 1)[1].lower() in ALLOWED_EXTENSIONS


if __name__ == "__main__":
    #app.run(debug=True)
    embedding = ranking.load_embedding(configuration["embedding"])
    loaded_ner = annotation.load_ner_model(configuration["ner"])
    app.run(host='0.0.0.0', port=80) 
    # app.run(debug=True)