class petel_exp
{
    constructor()
    {
        this.flags = {"attribute":false, "filter" : false, "filter_operation": false, "aggregator": false, "prediction_window": false};
        this.valid = false;
        this.active_feature = "attribute";
        this.rankings = {"attribute":[], "filter":[], "filter_operation":[], "aggregator":[], "prediction_window":[]};

        this.flags = {"attribute":{'active': true, 'completed': false, 'count': 0}, 
                            "filter" : {'active': false, 'completed': false, 'count': 0},
                            "filter_operation": {'active': false, 'completed': false, 'count': 0},
                            "aggregator": {'active': false, 'completed': false, 'count': 0},
                            "prediction_window": {'active': false, 'completed': false, 'count': 0}}
        
        this.counter = 0
        // print(self.flags)
        //  Initialize the PeTEL object to the uniform distribution
        for (var feature in this.flags){
            //  print(feature)
            for (var value in schema[feature]){
                this.rankings[feature].push({"name":schema[feature][value]["name"], "distribution":0})
            }
        }
    }


    update_all(text, schema)
    {
        var i = 0;
        for (var key in this.flags)
        {
            var falsified_values = this.get_falsified(this.rankings[key]);
            console.log(http_get('/ranks?text=' + text + '&features=' + JSON.stringify(schema[key])));
            this.rankings[key] = JSON.parse(http_get('/ranks?text=' + text + '&features=' + JSON.stringify(schema[key])));
            var counter = 0;
            for (var item in this.rankings[key])
            {
                for (var value in falsified_values)
                {
                    if (item["name"] == value["name"])
                    {
                        var temp = this.rankings[key].remove(item);
                        temp["wrong"] = true;
                        self.rankings[key].append(temp);
                    }
                }
                counter++;
            }
        }
        return;
    }


    update_active(text, schema)
    {
        var falsified_values = this.get_falsified(this.rankings[this.active_feature]);
        //console.log(falsified_values);
        //console.log(this.rankings[this.active_feature]);
        this.rankings[this.active_feature] = JSON.parse(http_get('/ranks?text=' + text + '&features=' + JSON.stringify(schema[this.active_feature])));
        //console.log(this.rankings[this.active_feature]);
        var counter = 0;
        var false_indices = [];
        var false_items = [];
        var offset = 0;
        for (var item in this.rankings[this.active_feature])
        {
            // Check each item to see if it's been falsified
            for (var value in falsified_values)
            {
                if (this.rankings[this.active_feature][item]['name'] == falsified_values[value]['name'])
                {
                    var temp = this.rankings[this.active_feature][item];
                    temp["wrong"] = true;
                    false_items.push(temp);
                    false_indices.push(item);
                }
            }
        }
        console.log(false_indices, false_items);
        // Remove the non-falsified values, and re-insert teh falsified values at the bottom
        for (var value in false_items)
        {
            this.rankings[this.active_feature].splice(false_indices[value]-offset, 1);
            this.rankings[this.active_feature].push(false_items[value]);
            offset++;
        }
        /*for (var item in this.rankings[this.active_feature])
        {
            var falsified_indices = [];
            var offset = 0;
            for (var value in falsified_values)
            {
                console.log('item:',item, this.rankings[this.active_feature][item], 'value:', falsified_values[value]);
                if ((this.rankings[this.active_feature][item]["name"] == falsified_values[value]["name"]) && !this.rankings[this.active_feature][item]["wrong"])
                {
                    var temp = this.rankings[this.active_feature][item];
                    //new_falsified.push(this.rankings[this.active_feature].splice(item, 1));
                    falsified_indices.push(item);
                    temp["wrong"] = true;
                    this.rankings[this.active_feature].push(temp);
                }
            }
            counter++;
            for (var i in falsified_indices)
            {
                this.rankings[this.active_feature].splice(falsified_indices[i-offset], 1);
                offset++;
            }
        }*/
        return;
    }


    falsify(index)
    {
        this.rankings[this.active_feature][index]["wrong"] = true;
        return;
    }


    get_falsified(features)
    {
        var falsified = [];
        for (var feature in features)
        {
            if (features[feature]["wrong"])
            {
                falsified.push(features[feature]);
            }
        }
        return falsified;
    }

    
    finished_feature()
    {
        var counter = 0;
        for (var key in this.flags)
        {
            if ((key == this.active_feature) && !(this.flags[key]))
            {
                this.flags[key] = true;
                counter++;
            }
            if (counter > 0)
            {
                this.active_feature = key
            }
        }
        return
    }


    is_complete()
    {
        for (var key in this.flags)
        {
            if (!this.flags[key])
            {
                return false;
            }
        }
        return true;
    }
}