# Atlas Gaussians Diffusion for 3D Generation

This is the code for our submission (anonymous)


## Requirement

We use Pytorch 2.2 with CUDA 11.8. First build some packages:
```
pip install ./diff-gaussian-rasterization_extended  # install gs render
cd util/emd
pip install .  # install EMD
```
All env info is in `environment.yaml`


## Dataset

For shapenet, we use the split from SRN. We use the rendering script and data from LN3Diff.


## Train the VAE

The first stage with 200 epochs
```
log_dir=output/vae/shapenet/car/base
config_path=config/shapenet/train_base.yaml
torchrun --nproc_per_node=8 main_ae.py --distributed --config ${config_path} --log_dir ${log_dir}
```

Then the second stage:
```
log_dir=output/vae/shapenet/car/full
config_path=config/shapenet/train_full.yaml
torchrun --nproc_per_node=8 main_ae.py --distributed --config ${config_path} --log_dir ${log_dir} \
                              --resume ${log_dir}/ckpt/checkpoint-199_model_only.pth
```
where `checkpoint-199_model_only.pth` is the model-only checkpoint from the first stage.


## Train the LDM using the pretrained VAE
```
log_dir=output/ldm/shapenet/car/kl_d512_m512_l64_d12_edm
torchrun \
    --nproc_per_node=8 main_class_cond.py \
    --accum_iter 1 \
    --config_ae ./config/shapenet/train_full.yaml \
    --model kl_d512_m512_l64_d12_edm \
    --ae_pth ./output/vae/shapenet/car/full/ckpt/checkpoint-600.pth \
    --log_dir ${log_dir} \
    --num_workers 30 \
    --batch_size 4 \
    --epochs 1000 \
    --warmup_epochs 50 \
    --lr 1e-4 \
```


## Latent sampling and generateion
```
CUDA_VISIBLE_DEVICES=0 python sample_class_cond.py \
                     --config_ae config/shapenet/train_full.yaml \
                     --ae_pth ./output/vae/shapenet/car/full/ckpt/checkpoint-600.pth \
                     --dm kl_d512_m512_l64_d12_edm \
                     --dm_pth output/ldm/shapenet/car/kl_d512_m512_l64_d12_edm/ckpt/checkpoint-999.pth
```






