#!/bin/bash

##################### Shell arguments descriptions #####################
# $1: should be the path to config.yaml
########################################################################

##################### slurm Arguments ##################################
#SBATCH --array=0-9
#SBATCH --job-name=baselines
#SBATCH --account=def-boyuwang
#SBATCH --time=00-3:00
#SBATCH --mem=16G
#SBATCH --nodes=1
#SBATCH --cpus-per-task=6
#SBATCH --gres=gpu:p100:1
#SBATCH --mail-user=waybaba2ww@gmail.com
#SBATCH --mail-type=BEGIN,END,FAIL,ALL,REQUEUE
#SBATCH --output=slurm_output/slurm-%A-%x-%a.out
#######################################################################

PROJECT_DIR=~/scratch/active-Learning-Label-Shift
ENVDIR=~/envs/py38
module load StdEnv/2020 cuda scipy-stack python/3.8
# virtualenv --no-download $ENVDIR
source $ENVDIR/bin/activate

SEED=$SLURM_ARRAY_TASK_ID
python train_baselines_cfg.py -c $1 -s $SEED
