#!/bin/bash

##################### Shell arguments descriptions #####################
# $1: should be the path to config.yaml
# $2: should be the seed number; or none
########################################################################

##################### slurm Arguments ##################################
#SBATCH --job-name=baselines
#SBATCH --account=def-boyuwang
#SBATCH --time=00-3:00
#SBATCH --mem=16G
#SBATCH --nodes=1
#SBATCH --cpus-per-task=6
#SBATCH --gres=gpu:p100:1
#SBATCH --mail-user=waybaba2ww@gmail.com
#SBATCH --mail-type=BEGIN,END,FAIL,ALL,REQUEUE
#SBATCH --output=slurm-%j-%x.out
#######################################################################

PROJECT_DIR=~/scratch/DomainBed
ENVDIR=~/envs/py38
# module load StdEnv/2020 cuda scipy-stack python/3.8
# virtualenv --no-download $ENVDIR
source $ENVDIR/bin/activate

cd $PROJECT_DIR
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset DenseDomainRotatedMNIST --edg --edg_direction backward --holdout_fraction 0.5 --env_density 7 --output_dir train_output/EDG-holdout_fraction_05-env_density_7
###bashfile_cmd_slot###