#!/bin/bash

##################### Shell arguments descriptions #####################
# $1: should be the path to config.yaml
# $2: should be the seed number; or none
########################################################################

##################### slurm Arguments ##################################
#SBATCH --job-name=baselines
#SBATCH --account=def-boyuwang
#SBATCH --time=00-72:00
#SBATCH --mem=64G
#SBATCH --nodes=1
#SBATCH --cpus-per-task=12
#SBATCH --gres=gpu:p100:4
#SBATCH --mail-user=waybaba2ww@gmail.com
#SBATCH --mail-type=BEGIN,END,FAIL,ALL,REQUEUE
#SBATCH --output=~/Documents/slurm_outputs/slurm-%j-%x.out
#######################################################################

PROJECT_DIR=~/scratch/DomainBed
ENVDIR=~/envs/py38
# module load StdEnv/2020 cuda scipy-stack python/3.8
# virtualenv --no-download $ENVDIR
source $ENVDIR/bin/activate

cd $PROJECT_DIR
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset DenseDomainRotatedMNIST --edg --edg_direction backward --holdout_fraction 0.5 --env_density 7 --output_dir train_output/EDG-holdout_fraction_05-env_density_7
###bashfile_cmd_slot###
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset EDGForestCover --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/ForestCover/a_test_EDG

'Portrait'
# origin EDG - portrait
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm ERM --dataset EDGForestCover --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/ForestCover/a_test_ERM --mmd_rate 0
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset EDGForestCover --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/ForestCover/a_test_EDG --mmd_rate 0

'OcularDisease'
# origin ERM - OcularDisease
python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm ERM --dataset OcularDisease --edg_direction backward --holdout_fraction 0.2 --env_distance 1 --env_number 35 --env_sample_number 1000 --seed 2 --output_dir EXPS/Ocular/a-test-ERM --batch_size 32
# origin EDG - OcularDisease
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset OcularDisease --edg_direction backward --holdout_fraction 0.2 --env_distance 1 --env_number 35 --env_sample_number 1000 --seed 2 --output_dir EXPS/Ocular/a-test-EDG --batch_size 8

'Circle & Sine'
# # origin ERM - EDGCircle
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm ERM --dataset EDGCircle --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/Circle/a_test_ERM --mmd_rate 0
# # origin EDG - EDGCircle
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset EDGCircle --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/Circle/a_test_EDG --mmd_rate 0
# # origin ERM - EDGSince
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm ERM --dataset EDGSine --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/Sine/a_test_ERM --mmd_rate 0
# # origin EDG - EDGSince
# python domainbed/scripts/train_edg.py --data_dir ../datasets_for_domainbed --algorithm EDG --dataset EDGSine --edg_direction backward --holdout_fraction 0.2 --env_distance 5 --env_number 5 --env_sample_number 200 --seed 2 --output_dir EXPS/Sine/a_test_EDG --mmd_rate 0