﻿# Towards Robust GNNs against Label noise (LPM)

The author implementation of LPM method described in the paper "Towards Robust GNNs against Label Noise".
To cite the paper please use the following BibTeX:
```text
@inproceedings{
anonymous2021towards,
title={Towards Robust Graph Neural Networks against Label Noise},
author={Anonymous},
booktitle={Submitted to International Conference on Learning Representations},
year={2021},
url={https://openreview.net/forum?id=H38f_9b90BO},
note={under review}
}
```
## Requirements
* Basic data science libraries: `numpy 1.19.1`, `scipy 1.3.1`,  `scikit-learn 0.19.2`,`networkx 2.1`.
* We use pytorch `python 3.7.0` and `pytorch 1.6.0`.
* Additionally, we implemented gradient based meta-learning algorithms in PyTorch using the `Higher 0.2.1` library, which can be found in the following [release](https://github.com/facebookresearch/higher).
## Description
* `train.py`
	 Train and evaluate LPM.
* `corrupte.py`
     Generate uniform label noise or flip label noise.
* `data.py`
     Load the data.
* `layer.py`
     Graph convolution layer.
 * `model.py`
     Graph Convolution Network and Aggregation Net.
 * `utils.py`
     Compute loss value and accuracy; Dropout for sparse matrix.


## Running the code
1. Install the required dependency packages
2. Specifying the argument  to choose a dataset and set the label noise type and ratio. An example is given below:
 ```sh 
python train.py --dataset cora --corruption_type flip --corruption_prob 0.4 --W ignore. 
```

