#! /usr/bin/env bash
set -e

GPU=${1:-1}
INTERVAL=${2:-1500}
NUM_ITERATION=${3:-4}

export CUDA_VISIBLE_DEVICES=${GPU}

#for ITERATION in {0..4}; do
for ((ITERATION=0; ITERATION<=$NUM_ITERATION; ITERATION++)); do
	STEP=$((ITERATION*INTERVAL))
	echo ${STEP}
	if [ -f log/checkpoints/*.${STEP}.ckpt ]
	then
		if [ -f ${STEP}.ckpt ]
		then
			continue
		fi
		
		cp log/checkpoints/*.${STEP}.ckpt ${STEP}.ckpt
		cd ..

		nohup python -u search.py 1 ./transformer_longtu/${STEP}.ckpt >${STEP}_bs1.out &
		echo launched testing with beam size=1 for model ${STEP}.ckpt

		nohup python -u search.py 4 ./transformer_longtu/${STEP}.ckpt >${STEP}_bs4.out &
		echo launched testing with beam size=4 for model ${STEP}.ckpt

		#echo testing with beam size=4 for model ${STEP}.ckpt
    #python -u search.py 4 ./transformer_longtu/${STEP}.ckpt >${STEP}_bs4.out 2>&1

		cd transformer_longtu
		
		break
	fi
done 
