import matplotlib
if matplotlib.get_backend() != 'agg' and matplotlib.get_backend() != 'Qt5Agg':
    matplotlib.use('TkAgg')
import matplotlib.pyplot as plt

import numpy as np
from numpy import array
import math
import numbers
import decimal
import random

import copy
import warnings
import os
import sys
from dataclasses import dataclass
from time import time
import time
import pickle

#from brl.utils.random_variable import RV
from brl.utils.random_variable import RV1d as RV
from brl.utils.visualization import LinePlot
from brl.utils.queues import *


def interval(first, last=None, gap=1):
    """
    print( list(interval(2,4)) )    : [2, 3, 4]
    print( list(interval(4,2)) )    : [4, 3, 2]
    print( list(interval(-2,4)) )   : [-2, -1, 0, 1, 2, 3, 4]
    print( list(interval(4,-2)) )   : [4, 3, 2, 1, 0, -1, -2]
    print( list(interval(4,-2,2)) ) : [4, 2, 0, -2]
    print( list(interval(4,-2,4)) ) : [4, 0]
    print( list(interval(2,2)) )    : [2]
    print( list(interval(0,0)) )    : [0]
    print( list(interval(4)) )      : [1, 2, 3, 4]
    print( list(interval(-4)) )     : []
    """
    if last is None:
        return range(1, first + 1, 1)
    else:
        return range(first, last + 1, gap) if first <= last else range(first, last - 1, -gap)

def onehot_encoding(label: int, shape) -> array:
    return np.squeeze(
        np.eye(1,
               shape[0] if type(shape) is tuple else shape,
               k=label,
               dtype=np.int8)
    )
def onehot_decoding(v: array) -> int:
    return v.argmax()

def print_githash():
    try:
        import git
        repo = git.Repo(search_parent_directories=True)
        sha = repo.head.object.hexsha
        print('commit #: ', sha, file=sys.stderr)
    except:
        print("cannot get git commit #.", file=sys.stderr)
print_githash()


#__all__ = ['np', 'array', 'plt', 'copy', 'math', 'random', 'RV']

