#! /usr/bin/env bash
set -e

for SEED in {0..0}
do
    echo "copying laeq to laeq_seed${SEED}"
    cp -r laeq laeq_seed${SEED}
    cd laeq_seed${SEED}/BRL/brl/envs/transformer_longtu
    TRAIN_GPU=$(( SEED+0 ))
    CUDA_VISIBLE_DEVICES=${TRAIN_GPU} bash train.sh ${SEED} 100000 5000
    cd ../../../../..
done

sleep 7200

while true
do
    for SEED in {0..0}
    do
        TEST_GPU=$(( SEED+1 ))
        echo "launching testing process with seed ${SEED} on GPU ${TEST_GPU}."
        cd laeq_seed${SEED}/BRL/brl/envs/transformer_longtu
        bash test.sh ${TEST_GPU} 5000 20
        cd ../../../../..
    done
    sleep 300
done
