from brl.utils import *

def get_bleu(beam_size):
    x,y = [],[]
    for step in (0, 1500, 3000, 4500, 5000, 6000):
        fname = str(step) + '_bs' + str(beam_size) + '.out'
        try:
            data = open(fname).read().splitlines()
            print('reading '+fname+'.')
            cbleu = float(data[-2].split()[1])
            sbleu = float(data[-2].split()[3])
            x.append(step)
            y.append(cbleu)
        except:
            pass
    for iteration in interval(2,20):
        step = iteration * 5000
        fname = str(step) + '_bs' + str(beam_size) + '.out'
        try:
            data = open(fname).read().splitlines()
            print('reading '+fname+'.')
            cbleu = float(data[-2].split()[1])
            sbleu = float(data[-2].split()[3])
            x.append(step)
            y.append(cbleu)
        except:
            pass

    return x,y

t_bs1, cbleu_bs1 = get_bleu(beam_size=1)
t_bs4, cbleu_bs4 = get_bleu(beam_size=4)

for x,y in zip(t_bs1,cbleu_bs1): print('{}\t{}'.format(x,y))
for x,y in zip(t_bs4,cbleu_bs4): print('{}\t{}'.format(x,y))

plot = LinePlot('step', 'corpus bleu')
plot.add_line(t_bs1, cbleu_bs1, label='beam size = 1')
plot.add_line(t_bs4, cbleu_bs4, label='beam size = 4')
plot.output('laeq.png')

#rv_cbleu_bs1 = RV('corpus bleu (beam size=1)', save_data=True)
#rv_cbleu_bs4 = RV('corpus bleu (beam size=4)', save_data=True)
#print(rv_cbleu_bs1)
#print(rv_cbleu_bs4)
