rm(list = ls())
library(ExtDist)
library(ggplot2)
library(latex2exp)
library(ggtext)

path <- ""
res_path <- ""

# source(paste0(path, "spd_functions.R"))

d <-  5
n <- 40
title <- latex2exp::TeX("$\\epsilon$-DP; $d = 15$")
res <- read.csv(file = paste0(res_path, "vanilla_DP_", d, "_", n, ".csv"))
res <- res[1:7, ]
res_1 <- data.frame(eps = res[, 2], mean = res[, 3], std = res[, 5])
res_2 <- data.frame(eps = res[, 2], mean = res[, 4], std = res[, 6])

p <- ggplot(res_1, aes(x = eps, y = mean)) +
  geom_line(data = res_1, aes(color = "EWL")) +
  geom_ribbon(
    aes(ymin = mean - 1 * std, ymax = mean + 1 * std), fill = "red",
    data = res_1, alpha = 0.3) +
  geom_point(data = res_1, size = 2, aes(color = "EWL", shape = "EWL")) + 
  geom_line(data = res_2, aes(color = "RL")) +
  geom_ribbon(
    aes(ymin = mean - 1 * std, ymax = mean + 1 * std), fill = "blue",
    data = res_2, alpha = 0.3) +
  geom_point(data = res_2, size = 2, aes(color = "RL", shape = "RL")) + 
  scale_color_manual(name='',
                     breaks=c('EWL', "RL"),
                     values=c('EWL'='red', 'RL'='blue')) +
  scale_shape_manual(name='',
                     breaks=c('EWL', "RL"),
                     values=c('EWL'=16, 'RL'=17))+
  ggtitle(title) +
  # ggtitle("<span style='font-size: 18pt;'>vanilla DP on SPD;</font><span style='font-size: 18pt;'>d = 3.</font>") +
  # theme(plot.title = element_markdown()) + 
  theme_classic() +
  theme(plot.title = element_text(size=20)) +
  theme(legend.position = c(0.8, 0.8)) +
  theme(text = element_text(size = 20)) +
  #coord_cartesian(ylim = c(0, 30)) + 
  ylab("Riemannian distance") + 
  xlab(latex2exp::TeX("$\\epsilon$"))
p

plot_path <- ""
ggsave(paste0("vanilla_DP_", d, ".png"), width = 10, height = 10, units = "cm", path = plot_path)
