import logging
logger = logging.getLogger('base')
from .sr3_modules.elan import ELAN
from .sr3_modules.esrt import ESRT

models = {'elan': ELAN, 'esrt': ESRT}

def create_model(opt):
    from .model import DDPM as M
    m = M(opt)
    logger.info('Model [{:s}] is created.'.format(m.__class__.__name__))
    return m


def get_model(cfg, m_name):
    """_summary_

    Args:
        cfg (dict): config files
        m_name (str): model name
    """
    model = models[m_name](**cfg[m_name])
    return model
