# Position Embedding Interpolation is All You Need for Efficient Image-to-image ViT

## Environment

- python 3.8
- pytorch >=1.11 
- torchvision  

you can follow the [official guidance](https://pytorch.org/get-started/previous-versions/) to install Pytorch. Then install the requirement package as shown:

```
$ cd  ./diffusion-SR
$ pip install -r requirements.txt
```

## Diffusion inpainting
If you want to train the difusion model, change the data path in *celeba_inpainting128.yaml* and use the follow command for train and test:
```bash
# train
python diffusion_train.py --cfg configs/xxx.yaml --output ./results/xxx

# test
python diffusion_test.py --cfg configs/xxx.yaml --ckpt ./xxx.pth --output ./results/xxx
```

## ViTSR 
For ViTSR, you can change the data path in *guideTSR_df2k_X4.yaml* and use the follow command for train and test:
```bash
# train
python vitsr_train.py --cfg configs/xxx.yaml --output ./results/xxx

# test
python vitsr_large_res_infer.py --cfg configs/xxx.yaml --hr_shape xx --lr_shape xx --ckpt ./xxx.pth --output ./results/xxx
```

## image to image
You can train ViT autoencoder on image deblur and colorization, just follow the command:
```bash
# train
python image2image_train.py --cfg configs/xxx.yaml --output ./results/xxx

# test
python image2image_test.py --cfg configs/xxx.yaml --ckpt ./xxx.pth --output ./results/xxx
```