#!/bin/bash
set -x

# Warning: Export VLLM_ATTENTION_BACKEND on every machine before starting Ray cluster.
# vLLM without XFORMERS will results in CUDA errors.
export CUDA_VISIBLE_DEVICES=1
export VLLM_ATTENTION_BACKEND=XFORMERS
export MODEL_PATH="/hpc2hdd/home/zyang398/***/models/Qwen/Qwen2.5-0.5B-Instruct"

# Train over a single node, 1 A100-80GB GPUs.
python3 -m verl.trainer.main_ppo \
    algorithm.adv_estimator=grpo \
    data.train_files=/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/train/math_cot_train.parquet \
    data.val_files=['/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/test/math.parquet','/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/test/minerva.parquet','/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/test/olympiad_bench.parquet','/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/test/aime.parquet','/hpc2hdd/home/zyang398/***/projs/TreeGRPO/TRPO-v4/data_qwen25_math_cot/test/amc.parquet'] \
    data.train_batch_size=16 \
    data.val_batch_size=512 \
    data.max_prompt_length=512 \
    data.max_response_length=1024 \
    actor_rollout_ref.model.path=$MODEL_PATH \
    actor_rollout_ref.actor.optim.lr=1e-6 \
    actor_rollout_ref.model.use_remove_padding=True \
    actor_rollout_ref.actor.ppo_mini_batch_size=64 \
    actor_rollout_ref.actor.use_dynamic_bsz=True \
    actor_rollout_ref.actor.ppo_max_token_len_per_gpu=24576 \
    actor_rollout_ref.actor.use_kl_loss=True \
    actor_rollout_ref.actor.kl_loss_coef=0.001 \
    actor_rollout_ref.actor.kl_loss_type=low_var_kl \
    actor_rollout_ref.actor.ulysses_sequence_parallel_size=1 \
    actor_rollout_ref.model.enable_gradient_checkpointing=True \
    actor_rollout_ref.actor.fsdp_config.param_offload=False \
    actor_rollout_ref.actor.fsdp_config.optimizer_offload=False \
    actor_rollout_ref.rollout.tensor_model_parallel_size=1 \
    actor_rollout_ref.rollout.name=vllm \
    actor_rollout_ref.rollout.temperature=0.6 \
    actor_rollout_ref.rollout.val_temperature=0.0 \
    actor_rollout_ref.rollout.gpu_memory_utilization=0.8 \
    actor_rollout_ref.rollout.n=8 \
    +actor_rollout_ref.rollout.step_length=256 \
    actor_rollout_ref.rollout.n_val=1 \
    actor_rollout_ref.ref.fsdp_config.param_offload=True \
    +reward_model.ignore_think=True \
    algorithm.kl_ctrl.kl_coef=0.001 \
    trainer.critic_warmup=0 \
    trainer.logger=['console','wandb'] \
    trainer.project_name='TreeGRPO' \
    trainer.experiment_name='qwen2.5-0.5b-instruct-math-1k-bs16-TRPOv3-qwen25mathcot' \
    +trainer.val_before_train=False \
    trainer.n_gpus_per_node=1 \
    trainer.nnodes=1 \
    trainer.save_freq=5 \
    trainer.test_freq=20 \
    trainer.default_hdfs_dir=null \
    trainer.total_epochs=30 "${@:1}"
