# Yooop: You Only Optimize One Prototype per Class for Non-Exemplar Incremental Learning

---


## 1. Get dataset
Get the dataset cifar100, TinyImageNet, or other datasets. Then set the dataset as follow structure.
> cifar100 \
> | \
> |____ images\
> |----|\
> |----|____ train\
> |----|----|____ {id}\
> |----|--------|____ {img_name}.jpg\
> |----|\
> |----|____ test\
> |---------|____ {id}\
> |-------------|____ {img_name}.jpg\
> |\
> |____ train_list.txt\
> |\
> |____ test_list.txt

The format of "train_list.txt" and "test_list.txt" is like:
> images/train/33/10_&forest&_large_natural_outdoor_scenes_12425.jpg 33
> images/train/33/10_&forest&_large_natural_outdoor_scenes_10642.jpg 33
> images/train/33/10_&forest&_large_natural_outdoor_scenes_20188.jpg 33
> images/train/33/10_&forest&_large_natural_outdoor_scenes_48920.jpg 33

## 2. Get "dataset.pkl"
Set the "$data_root_path" in the "transform_*.py", the "$data_root_path" is the parent path of dataset, like "$data_root_path/cifar100", then run the command:
```bash
python transform_{dataset}.py
```

## 3. Run the CIL experiments
Set the "--dataset_path" in the "YoooP_*.sh" then run with the bash file:
```bash
bash YoooP_*.sh
```