from __future__ import print_function
import os
import numpy as np
import os.path as osp
import random
import xml.etree.ElementTree as ET
import pickle
# from utils import *
ospj = osp.join
ospeu = osp.expanduser

def may_make_dir(path):
    """
    Args:
        path: a dir, or result of `os.path.dirname(os.path.abspath(file_path))`
    Note:
        `os.path.exists('')` returns `False`, while `os.path.exists('.')` returns `True`!
    """
    # This clause has mistakes:
    # if path is None or '':

    if path in [None, '']:
        return
    if not os.path.exists(path):
        os.makedirs(path)

def save_pickle(obj, path):
    """Create dir and save file."""
    may_make_dir(osp.dirname(osp.abspath(path)))
    with open(path, 'wb') as f:
        pickle.dump(obj, f, protocol=2)


def veri_partitions(train_path, paths_dic):
    test_path = paths_dic['test_path']
    partition_path = paths_dic['partition_path']

    ######## creat train ########
    train_im_names = []
    train_im_ids = []
    train_ids2labels = {}

    with open(train_path, 'r') as f:
        lines = f.readlines()
        for line in lines:
            tmp_data = line.rstrip().split(' ')
            train_im_names.append(tmp_data[0])
            train_im_ids.append(tmp_data[1])

    tmp_train_im_ids = list(set(train_im_ids))
    # tmp_train_im_ids.sort()
    random.shuffle(tmp_train_im_ids)

    # tmp_train_im_ids = [
    #     'n04311004', 'n02099601', 'n02814860', 'n03983396', 'n02843684',
    #     'n02281406', 'n03085013', 'n04008634', 'n04074963', 'n03854065',
    #     'n03838899', 'n04501370', 'n04366367', 'n01917289', 'n01784675',
    #     'n03355925', 'n03400231', 'n02666196', 'n02988304', 'n03649909',
    #     'n03992509', 'n03126707', 'n03617480', 'n02480495', 'n04456115',
    #     'n03976657', 'n07768694', 'n01629819', 'n07615774', 'n03160309',
    #     'n02268443', 'n03179701', 'n03930313', 'n02395406', 'n04596742',
    #     'n02403003', 'n09246464', 'n07695742', 'n07920052', 'n02423022',
    #     'n03100240', 'n03763968', 'n02795169', 'n02999410', 'n02129165',
    #     'n01910747', 'n01855672', 'n02236044', 'n04285008', 'n03970156',
    #     'n03804744', 'n02415577', 'n03902125', 'n01774750', 'n03977966',
    #     'n02481823', 'n01698640', 'n03891332', 'n04328186', 'n04133789',
    #     'n02509815', 'n02769748', 'n03937543', 'n02123394', 'n07583066',
    #     'n04540053', 'n04099969', 'n03393912', 'n02125311', 'n02504458',
    #     'n02437312', 'n09428293', 'n03637318', 'n02909870', 'n01770393',
    #     'n02814533', 'n01742172', 'n02815834', 'n02231487', 'n03089624',
    #     'n02190166', 'n04417672', 'n02808440', 'n02977058', 'n02802426',
    #     'n04118538', 'n02124075', 'n02699494', 'n02321529', 'n02113799',
    #     'n04023962', 'n04254777', 'n07720875', 'n04371430', 'n02841315',
    #     'n04487081', 'n01950731', 'n06596364', 'n02165456', 'n02883205',
    #     'n01983481', 'n04507155', 'n07873807', 'n07715103', 'n02094433',
    #     'n04532670', 'n02132136', 'n02963159', 'n03201208', 'n01644900',
    #     'n02669723', 'n04465501', 'n02892201', 'n07579787', 'n02823428',
    #     'n02837789', 'n02486410', 'n02788148', 'n03837869', 'n02948072',
    #     'n04275548', 'n04149813', 'n02085620', 'n07753592', 'n02791270',
    #     'n01641577', 'n03796401', 'n02730930', 'n02074367', 'n04532106',
    #     'n04070727', 'n01443537', 'n03255030', 'n04251144', 'n02364673',
    #     'n03404251', 'n03599486', 'n03706229', 'n04398044', 'n02099712',
    #     'n04562935', 'n09256479', 'n04399382', 'n07734744', 'n03447447',
    #     'n01768244', 'n02917067', 'n03584254', 'n03980874', 'n03814639',
    #     'n07614500', 'n04486054', 'n03014705', 'n02058221', 'n04265275',
    #     'n02002724', 'n03733131', 'n07875152', 'n12267677', 'n03388043',
    #     'n02927161', 'n03662601', 'n04259630', 'n04356056', 'n02206856',
    #     'n01945685', 'n04560804', 'n07747607', 'n02279972', 'n03042490',
    #     'n09332890', 'n04179913', 'n03026506', 'n07871810', 'n03770439',
    #     'n02410509', 'n03250847', 'n03424325', 'n07711569', 'n04146614',
    #     'n03444034', 'n02123045', 'n04067472', 'n02793495', 'n01774384',
    #     'n03544143', 'n01882714', 'n02226429', 'n02906734', 'n04597913',
    #     'n09193705', 'n01984695', 'n02056570', 'n03670208', 'n07749582',
    #     'n01944390', 'n04376876', 'n02233338', 'n02106662', 'n02950826'
    # ]
    random.shuffle(tmp_train_im_ids)
    print(tmp_train_im_ids)
    train_ids2labels.update(
        dict(zip(tmp_train_im_ids, list(range(len(tmp_train_im_ids))))))

    test_im_names = []  # osp.join('image_test', im_name)
    test_im_ids = []
    test_ids2labels = {}


    with open(test_path, 'r') as f:
        lines = f.readlines()
        for line in lines:
            tmp_data = line.rstrip().split(' ')
            test_im_names.append(tmp_data[0])
            test_im_ids.append(tmp_data[1])


    tmp_test_im_ids = list(set(test_im_ids))
    tmp_test_im_ids.sort()
    # test_ids2labels.update(
    #     dict(zip(tmp_test_im_ids, list(range(len(tmp_test_im_ids))))))


    new_partitions = {
        'train_im_names': train_im_names,
        'train_im_ids': train_im_ids,
        'train_ids2labels': train_ids2labels,
        'test_im_names': test_im_names,
        'test_im_ids': test_im_ids,
        'test_ids2labels': train_ids2labels,
    }

    save_pickle(new_partitions, partition_path)
    # print(tmp_train_im_ids)
    # print(tmp_test_im_ids)
    print('Partition file saved to {}'.format(partition_path))


if __name__ == '__main__':
    data_root_path = ''
    dataset_path = os.path.join(data_root_path, 'tiny-imagenet-200')
    train_path = os.path.join(dataset_path, 'train_list.txt')
    test_path = os.path.join(dataset_path, 'test_list.txt')
    partition_path = osp.join(dataset_path, 'tiny-imagenet-200.pkl')
    paths_dic = {
        'test_path': test_path,
        'partition_path': partition_path
    }
    veri_partitions(train_path, paths_dic)


# [68, 56, 78, 8, 23, 84, 90, 65, 74, 76, 40, 89, 3, 92, 55, 9, 26, 80, 43, 38, 58, 70, 77, 1, 85, 19, 17, 50, 28, 53, 13, 81, 45, 82, 6, 59, 83, 16, 15, 44, 91, 41, 72, 60, 79, 52, 20, 10, 31, 54, 37, 95, 14, 71, 96, 98, 97, 2, 64, 66, 42, 22, 35, 86, 24, 34, 87, 21, 99, 0, 88, 27, 18, 94, 11, 12, 47, 25, 30, 46, 62, 69, 36, 61, 7, 63, 75, 5, 32, 4, 51, 48, 73, 93, 39, 67, 29, 49, 57, 33]