import torch
def smooth_label(labels, classes_num, smoothing=0.0):
    """
    if smoothing == 0, it's one-hot method
    if 0 < smoothing < 1, it's smooth method
    """
    assert 0 <= smoothing < 1
    confidence = 1.0 - smoothing
    label_shape = torch.Size((labels.size(0), classes_num))
    with torch.no_grad():
        true_dist = torch.empty(size=label_shape, device=labels.device)
        true_dist.fill_(smoothing / (classes_num - 1))
        true_dist.scatter_(1, labels.data.unsqueeze(1), confidence)
    return true_dist