from PIL import ImageFilter
import random


class multiCropsTransform:
    """Take two random crops of one image as the query and key."""

    def __init__(self, base_transform,task_num=8):
        self.base_transform = base_transform
        self.task_num = task_num

    def __call__(self, x):
        trans_x = []
        for i in range(self.task_num ):
            trans_x.append(self.base_transform(x))
        return trans_x


class GaussianBlur(object):
    """Gaussian blur augmentation in SimCLR https://arxiv.org/abs/2002.05709"""

    def __init__(self, sigma=[.1, 2.]):
        self.sigma = sigma

    def __call__(self, x):
        sigma = random.uniform(self.sigma[0], self.sigma[1])
        x = x.filter(ImageFilter.GaussianBlur(radius=sigma))
        return x
