# coding: utf-8
###
 # @file   template.py
 # @author Sébastien Rouault <sebastien.rouault@alumni.epfl.ch>
 #
 # @section LICENSE
 #
 # Copyright © 2020-2021 École Polytechnique Fédérale de Lausanne (EPFL).
 # See LICENSE file.
 #
 # @section DESCRIPTION
 #
 # Template code for an attack.
 # See `__init__.py` docstring for the interface.
###

from . import register

# ---------------------------------------------------------------------------- #
# Attack template

def attack(grad_honests, f_real, **kwargs):
  """ Generate non-finite gradients.
  Args:
    grad_honests Non-empty list of honest gradients
    f_real       Number of Byzantine gradients to generate
    ...          Ignored keyword-arguments
  Returns:
    Generated Byzantine gradients
  """
  raise NotImplementedError("I am template code, please replace me with useful stuff")

def check(grad_honests, f_real, **kwargs):
  """ Check parameter validity for this attack.
  Args:
    grad_honests Non-empty list of honest gradients
    f_real       Number of Byzantine gradients to generate
    ...          Ignored keyword-arguments
  Returns:
    Whether the given parameters are valid for this attack
  """
  return "I am template code, you should not be using me"

# ---------------------------------------------------------------------------- #
# Attack registering

# Register the attack
register("template", attack, check)
