# As-ViT: Auto-scaling Vision Transformers without Training

**Note**: We implemented topology search (sec. 3.3) and scaling (sec. 3.4) in this code base in PyTorch. Our training code is based on Tensorflow and Keras for TPU training, which we did not have enough time to clean.

### Installation
```bash
pip install -r requirements.txt
```

### Topology Search
```bash
CUDA_VISIBLE_DEVICES=0 OMP_NUM_THREADS=4 python ./search/reinforce.py --save_dir ./output/REINFORCE-imagenet --data_path /path/to/imagenet
```

### Scaling
```bash
CUDA_VISIBLE_DEVICES=0 OMP_NUM_THREADS=4 python ./search/grow.py --save_dir ./output/GROW-imagenet \
--arch "8,2,1,3|4,1,1,2|4,1,1,4|4,1,1,6|32" --data_path /path/to/imagenet
```
