import abc
import logging
from typing import Any

import numpy as np
from numpy.random import default_rng

from cml.data.base import DATAPATH, Dataset, Dataloader, MetaDataset


class DatasetGenerator(abc.ABC):
    def __init__(self, seed):
        self.rng = np.random.default_rng(seed)

    @abc.abstractmethod
    def sample(self, num_tasks, num_samples):
        pass
