"""
Copyright (c) Anonymous authors
All rights reserved.

MIT License

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
import abc
from typing import Tuple

import haiku as hk
import jax.numpy as jnp


class MetaModule(abc.ABC):
    def __init__(self, loss_fn_inner, loss_fn_outer) -> None:
        self.loss_fn_inner = loss_fn_inner
        self.loss_fn_outer = loss_fn_outer

    @abc.abstractmethod
    def __call__(
        self, rng, state, hstate, params, hparams, input
    ) -> Tuple[jnp.ndarray, Tuple[hk.State, hk.State]]:
        pass

    @abc.abstractmethod
    def reset_hparams(self, rng, sample_input) -> Tuple[hk.Params, hk.State]:
        pass

    @abc.abstractmethod
    def reset_params(self, rng, hparams, sample_input) -> Tuple[hk.Params, hk.State]:
        pass
