"""
Copyright (c) Anonymous authors
All rights reserved.

MIT License

Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the “Software”), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED “AS IS”, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
"""
import numpy as np

from cml.data.base import Dataset

from cml.data.dataset.base import DatasetGenerator


class Sinusoid(DatasetGenerator):
    def __init__(self, seed):
        super().__init__(seed)

    def sample(self, num_tasks, num_samples):
        def sinusoid(inputs, amplitude, phase):
            targets = amplitude * np.sin(inputs + phase)

            return targets

        inputs = self.rng.uniform(low=-5.0, high=5.0, size=(num_tasks, num_samples, 1))
        amplitudes = self.rng.uniform(low=0.1, high=0.5, size=(num_tasks, 1, 1))
        phases = self.rng.uniform(low=0.0, high=np.pi, size=(num_tasks, 1, 1))

        targets = np.vectorize(sinusoid)(inputs, amplitudes, phases)

        return Dataset(x=inputs, y=targets)
