# BioDiscoveryAgent

BioDiscoveryAgent is an AI agent for closed loop design of 
biological experiments. BioDiscoveryAgent designs genetic perturbation experiments 
using only an LLM paired with a suite of tools (literature search, gene search, AI critique).

## Installation

Install required packages using the following command:
```
pip install -r requirements.txt
```
Claude API key is required for running the code. Please visit the [Anthropic website](https://docs.anthropic.com/en/docs/getting-access-to-claude) 
for more information

## Datasets

1. IFNG
2. IL2
3. Carnevale22_Adenosine
4. Scharenberg22
5. Sanchez21_down
   
## Commands

Python 3 is required to run the scripts (3.10 recommended).To run the baseform BioDiscoveryAgent with Claude-3.5-Sonnet on the IFNG dataset:

```
python research_assistant.py  --task perturb-genes-brief --model claude-3-5-sonnet-20240620 --run_name test --data_name IFNG --steps 5 --num_genes 128 --log_dir sonnet
```
To run the agent with all tools:
```
python research_assistant.py  --task perturb-genes-brief --model claude-3-5-sonnet-20240620 --run_name test --data_name IFNG --steps 5 --num_genes 128 --log_dir sonnet --lit_review True --critique True --reactome True
```
You can also similarly run with OpenAI models:
```
python research_assistant.py  --task perturb-genes-brief --model gpt-4o --run_name test --data_name IFNG --steps 5 --num_genes 128 --log_dir v1
```
To calculate hit rate on the predictions:
```
python analyze.py  --model sonnet --dataset IFNG --trials 1 --rounds 5
```