#!/usr/bin/env bash
##################################################################################################
DATASET=(
    "humaneval"
    #"mbpp"
)

GRAMMAR_FILE_TYPE="gpt"
# Components: "gpt" or "base" or "our"

TRAIN_MODE="SFT" # This means SFT or RL
    # Components: "SFT" or "RL"

INFERENCE_GPT_MODEL="o4-mini"
# Default: "o4-mini"
# Components: "o4-mini", "gpt-4o-mini"

if [ "$GRAMMAR_FILE_TYPE" == "gpt" ]; then
    INFERENCE_MODEL=(
        $INFERENCE_GPT_MODEL
    )
else
    # if GRAMMAR_FILE_TYPE is base, then use the following models
    INFERENCE_MODEL=(
        "DeepSeek-R1-Distill-Qwen-14B"
        #"Mistral-Nemo-Base-2407"
        #"Phi-4-reasoning-plus"
    )
fi

TIMEOUT=30
NUM_SOLUTIONS=5
##################################################################################################
for DATASET in "${DATASET[@]}"; do
    for MODEL in "${INFERENCE_MODEL[@]}"; do
    
    if [ "$MODEL" == "DeepSeek-R1-Distill-Qwen-14B" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="DeepSeek"
    elif [ "$MODEL" == "Phi-4-reasoning-plus" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="Phi"
    elif [ "$MODEL" == "Mistral-Nemo-Base-2407" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="Mistral"
    elif [ "$MODEL" == "o4-mini" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="o4-mini"
    elif [ "$MODEL" == "gpt-4o-mini" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="gpt-4o-mini"
    else
        echo "Invalid MODEL"
        exit 1
    fi

    if [ "$GRAMMAR_FILE_TYPE" == "gpt" ]; then
        GRAMMAR_FILE="../../code/output_${GRAMMAR_FILE_TYPE}/original/${INFERENCE_GPT_MODEL}/grammar_assert_specification/${DATASET}_${INFERENCE_GPT_MODEL}_sft.jsonl"
        OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/parsing_data/grammar_assert_specification/${INFERENCE_GPT_MODEL}/${INFERENCE_GPT_MODEL}-parsing.json"
        TEST_CASE_OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/after_quality/grammar_assert_specification/${INFERENCE_GPT_MODEL}/"
    elif [ "$GRAMMAR_FILE_TYPE" == "base" ]; then
        GRAMMAR_FILE="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/inference/grammar_assert_specification/${MODEL}/generated_step_all.json"
        OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/parsing_data/grammar_assert_specification/${MODEL}/${MODEL}-generated_step_all.json"
         TEST_CASE_OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/parsing_data/grammar_assert_specification/${MODEL}"
    elif [ "$GRAMMAR_FILE_TYPE" == "our" ]; then
        GRAMMAR_FILE="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/inference/grammar_assert_specification/${MODEL}-${TRAIN_MODE}/${DATASET}_grammar_${TRAIN_MODE}@1.jsonl"
        OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/parsing_data/grammar_assert_specification/${MODEL}-${TRAIN_MODE}/${MODEL}-generated_step_all.json"
        TEST_CASE_OUTPUT_PATH="../../code/output_${GRAMMAR_FILE_TYPE}/${DATASET}/parsing_data/grammar_assert_specification/${MODEL}-${TRAIN_MODE}"
    else
        echo "Invalid GRAMMAR_FILE_TYPE"
        exit 1
    fi

    if [ "$GRAMMAR_FILE_TYPE" == "our" ]; then
        TEST_CASE_OUTPUT_PATH_MODEL="${MODEL}-${TRAIN_MODE}"
    else
        TEST_CASE_OUTPUT_PATH_MODEL="${MODEL}"
    fi

    python ../../code/utils/grammar_smt_tool_gpt_format.py \
    --model $MODEL \
    --grammar_file $GRAMMAR_FILE \
    --output_path $OUTPUT_PATH \
    --test_case_output_path $TEST_CASE_OUTPUT_PATH \
    --test_case_output_path_model $TEST_CASE_OUTPUT_PATH_MODEL \
    --solver "z3" \
    --timeout $TIMEOUT \
    --num_solutions $NUM_SOLUTIONS
    done
done