#!/usr/bin/env bash
# This is a script for inference parsing.
##################################################################################################
### **Default parameters**
TEST_CASE_TYPES=(
  #"assert_specification" 
  "multi_assert_specification"
  #"functionality_specification"
  )

DATASETS=(
  "humaneval" 
  "mbpp"
  )
##################################################################################################
### **Custom parameters**
MODEL_NAMES=( # Add model names here. This means what model to use for parsing.
  ## Base Model
  #"DeepSeek-R1-Distill-Qwen-14B"
  #"Mistral-Nemo-Base-2407"
  #"Qwen3-14B"
  #"Phi-4-reasoning-plus"

  ## ChatGPT generation
  #"gpt-4o-mini"
  "o4-mini"

  ## SFT, RL Model
  #"ours_sft-deepseek"
  #"ours_rl-deepseek"
)

##################################################################################################
for DATASET in "${DATASETS[@]}"; do
  for TEST_CASE_TYPE in "${TEST_CASE_TYPES[@]}"; do
    for MODEL_NAME in "${MODEL_NAMES[@]}"; do
      echo "Parsing Model: $MODEL_NAME | Dataset: $DATASET | TestCase: $TEST_CASE_TYPE"
      python ../../code/utils/inference_parsing.py \
        --dataset_type "$DATASET" \
        --model_name  "$MODEL_NAME" \
        --test_case_type "$TEST_CASE_TYPE"
    done
  done
done