from torchvision import transforms
from torch.utils.data import DataLoader
import torchvision

def CIFAR100DataLoader(batch_size):
    transformer = transforms.Compose([transforms.Resize((240,240)),
                                      transforms.ToTensor(),
                                      transforms.Normalize((0.5, 0.5, 0.5), (0.5, 0.5, 0.5))
                                     ])


    training_data = torchvision.datasets.CIFAR100(root =  "C:/Users/dabmv/PycharmProjects/pythonProject/dataset", train = True, transform =transformer , target_transform = None,
    download=True)
    test_data = torchvision.datasets.CIFAR100(root =  "C:/Users/dabmv/PycharmProjects/pythonProject/dataset", train = False, transform = transformer, target_transform = None,download=True)



    # 데이터로더를 생성합니다.
    train_dataloader = DataLoader(training_data, batch_size=batch_size, shuffle=True)
    test_dataloader = DataLoader(test_data, batch_size=batch_size, shuffle=True)

    return train_dataloader, test_dataloader