**GenTUS** is a data-driven user simulator with transformers, which can generate semantic actions and utterence. It is able to trasfer to a new ontology in a zero-shot fashion.

## Introduction
We propose a generative transform-based user simulator (GenTUS) in this work. GenTUS consists of an encoder-decoder structure, which can optimise both the user policy and natural language generation jointly. GenTUS generates semantic actions and natural language utterances, preserving interpretability and enhancing language variation. 

The code of TUS is in `convlab/policy/genTUS`.

## Usage
### Train GenTUS from scratch
You need to generate the input files by `build_data.py`, then train the model by `train_model.py`.
```
python3 convlab/policy/genTUS/unify/build_data.py --dataset $dataset --add-history --dial-ids-order $dial_ids_order --split2ratio $split2ratio
python3 convlab/policy/genTUS/train_model.py --data-name $dataset --dial-ids-order $dial_ids_order --split2ratio $split2ratio --batch-size 8
```

`dataset` can be `multiwoz21`, `sgd`, `tm`, `sgd+tm`, or `all`.
`dial_ids_order` can be 0, 1 or 2
`split2ratio` can be 0.01, 0.1 or 1

The `build_data.py` will generate three files, `train.json`, `validation.json`, and `test.json`, under the folder `convlab/policy/genTUS/unify/data/${dataset}_${dial_ids_order}_${split2ration}`. 
We trained GenTUS on A100 or RTX6000.

### Evaluate TUS
```
python3 convlab/policy/genTUS/evaluate.py --model-checkpoint $model_checkpoint --input-file $in_file --dataset $dataset --do-nlg
```
The `in_file` is the file generated by `build_data.py`.

### Train a dialogue policy with GenTUS
You can use it as a normal user simulator by `PipelineAgent`. For example,
```python
from convlab.dialog_agent import PipelineAgent
from convlab.util.custom_util import set_seed

model_checkpoint = 'convlab/policy/genTUS/unify/experiments/multiwoz21-exp'
usr_policy = UserPolicy(model_checkpoint, mode="semantic")
simulator = PipelineAgent(None, None, usr_policy, None, 'user')
```
then you can train your system with this simulator.

You can also change the `mode` to `"language"`, then GenTUS will response in natural language instead of semantic actions.


<!---citation--->
## Citing

```
@inproceedings{lin-etal-2022-gentus,
    title = "{G}en{TUS}: Simulating User Behaviour and Language in Task-oriented Dialogues with Generative Transformers",
    author = "Lin, Hsien-chin  and
      Geishauser, Christian  and
      Feng, Shutong  and
      Lubis, Nurul  and
      van Niekerk, Carel  and
      Heck, Michael  and
      Gasic, Milica",
    booktitle = "Proceedings of the 23rd Annual Meeting of the Special Interest Group on Discourse and Dialogue",
    month = sep,
    year = "2022",
    address = "Edinburgh, UK",
    publisher = "Association for Computational Linguistics",
    url = "https://aclanthology.org/2022.sigdial-1.28",
    pages = "270--282",
    abstract = "User simulators (USs) are commonly used to train task-oriented dialogue systems via reinforcement learning. The interactions often take place on semantic level for efficiency, but there is still a gap from semantic actions to natural language, which causes a mismatch between training and deployment environment. Incorporating a natural language generation (NLG) module with USs during training can partly deal with this problem. However, since the policy and NLG of USs are optimised separately, these simulated user utterances may not be natural enough in a given context. In this work, we propose a generative transformer-based user simulator (GenTUS). GenTUS consists of an encoder-decoder structure, which means it can optimise both the user policy and natural language generation jointly. GenTUS generates both semantic actions and natural language utterances, preserving interpretability and enhancing language variation. In addition, by representing the inputs and outputs as word sequences and by using a large pre-trained language model we can achieve generalisability in feature representation. We evaluate GenTUS with automatic metrics and human evaluation. Our results show that GenTUS generates more natural language and is able to transfer to an unseen ontology in a zero-shot fashion. In addition, its behaviour can be further shaped with reinforcement learning opening the door to training specialised user simulators.",
}


```

## License

Apache License 2.0
