## Data Setup
This experiment is performed on the [20bn-something-something-v2](https://developer.qualcomm.com/software/ai-datasets/something-something) dataset. Please follow the link and download the dataset.
The unzipped folder called `20bn-something-something-v2` should be put under the `data` folder.
As the original dataset including all the bounding boxes is very large, we only provide a mini dataset with 100 training examples and 100 test examples.

## Run the Script
To train a new model from scratch, we can run the following script:
```
python run.py --phase train --learning-rate 0.0001 --batch-size 3 --save_model --with-violation --use-contrast
```

The optional arguments `--use-contrast` and `--with-violation` decides whether to use the contrast loss and the violation loss.

To test the performance of an existing model, we can run the following script:
```
python run.py --phase test --model_type contrast
```
There are three pre-trained models: `plain`, `contrast`, and `violation`.
The `plain` model is trained with just temporal loss, the `contrast` model uses both temporal and contrastive loss, and the `violation` model uses temporal, contrastive, and semantic loss.
