## Environment Setup
Please clone the [jukebox](https://github.com/openai/jukebox/tree/08efbbc1d4ed1a3cef96e08a931944c8b4d63bb3) git repository into the `MUGEN` folder by running the following instructions.

```
git clone https://github.com/openai/jukebox.git
cd jukebox
python -m pip install -r requirements.txt
python -m pip install -e .
```

## Dataset Setup
Please run the following command to download the dataset into the `MUGEN` directory.
```
mkdir -p datasets/coinrun
cd datasets/coinrun
wget http://dl.noahmt.com/creativity/data/MUGEN_release/coinrun.zip
unzip coinrun.zip
cd ...
```
For more information, please refer [here](https://mugen-org.github.io/download).

## Model

Run the following command to download the pre-trained checkpoints.
```
mkdir checkpoints
cd checkpoints
wget https://dl.noahmt.com/creativity/data/MUGEN_release/checkpoints.zip
unzip checkpoints
cd ..
```

## Run the Script
To train a new model from scratch, we can run the following script:
```
python run.py --phase train --lr 0.0001 --batch_size 3
```

To test the performance of an existing model, we can run the following script:
```
python run.py --phase test
```
Due to the limitation of the upload size, we cannot include a pretrained model
inside this directory.
