static = ["is_bendable", "is_fluid", "is_holdable", "is_rigid", "is_tearable", "neq"]
unary = [ "broken", "close", "closed", "deformed", "empty", "far", "folded", 
         "has_hole", "high",  "low", "left", "nextto", "onsurface", "open", "right", 
         "stacked",  "stretched", "torn", "twisted",  "upright",]
binary = ["above", "attached", "behind", "fits",  "in", "infront", "on",  "touching", 
          "under", "visible",]
constants = ["hand"]
locations = ["early", "mid", "late"]

user = '''
You are a super user in logic programming. 
'''

context = f'''
Here are some predicates you can use. 
A unary predicate takes in one argument. For example, close(A) means A is close to the camera.
A binary predicate takes in two arguments. For example, above(A, B) means A is above B.
Static predicates: {', '.join(static)}
Unary predicates: {', '.join(unary)}
Binary predicates: {', '.join(binary)}
Constants: {', '.join(constants)}
The location in the video can be: {', '.join(locations)}
'''

dig_example = '''
Action: dig
Explanation: Digging [A] out of [B]
- Static properties: 
1. A is holdable 
2. B is not rigid
3. entity A and B are not equvalent
- Programmatic Version:
1. is_holdable(A)
2. not(is_rigid(B))
3. neq(A, B)

Time_stamp_1: 
1. Not A and B are far away from the camera
2. A is in B
3. A and B are not touched by hand
4. A is not visible, but B is visible, and there is a hand that is visible
- Programmatic Version:
1. not(far(A)), not(far(B))
2. in(A, B)
3. not(touching(A, hand)), not(touching(B, hand))
4. not(visible(A)), visible(B), visible(hand)
- Duration of time stamp 1: Short 
- Location in the video: Early

Time_stamp_2:
1. A become visible
2. A is in a hand
3. A is not touching B
- Programmatic Version:
1. visible(A)
2. in(A, hand)
3. not(touching(A, B))
- Duration of Time_stamp_2: Short
- Duration between Time_stamp_1 and Time_stamp_2: long
'''

hold_over_example = '''
Action: hold-over
Explanation: Holding [A] over [B]
- Static properties: 
1. entity A and B are not equvalent
- Programmatic Version: 
1. neq(A, B)

Time_stamp_1: 
1. the entity A is above B and they are not touching each other
2. the camera is not far from the entity B
3. the entity A is in a hand
4. the entity B is visible
- Programmatic Version:
1. above(A, B), not(touching(A, B))
2. not (far (B))
3. in(A, hand)
4. visible(B)
- Duration of time stamp 1: Short 
- Location in the video: Early
'''

plug_example = '''
Action: plug
Explanation: Plugging [A] into [B]
- Static properties: 
1. entity A and B are not equvalent
2. entity B is rigid
- Programmatic Version: 
1. neq(A, B)
2. is-rigid(B)

Time_stamp_1: 
1. The camera is not far from B
2. The entity A fits B, and it is in a hand
3. The object A and B are not touching each other
4. The object B is not touched by a hand
5. The object B is visible
- Programmatic Version:
1. not (far(V))
2. fits(A, B), in (A, hand)
3. not(touching(A, B))
4. not(touching(B, hand))
5. visible(b)
- Duration of time stamp 1: Short 
- Location in the video: Early


Time_stamp_2: 
1. The object A is attached to B
2. A is in B
3. A is no longer touched by a hand
- Programmatic Version:
1. attached (A, B)
2. in (A, B)
3. not (touching (A, hand))

- Duration of Time_stamp_2: Short
- Duration between Time_stamp_1 and Time_stamp_2: long
'''


    
all_examples = [dig_example, hold_over_example, plug_example]
few_shot_prompt = '\n'.join(all_examples)
prompt = '\n'.join([user, context, few_shot_prompt])

def wrap_prompt(action_ls, few_shot=True):
    output_prompt = [context]
    if few_shot:
        output_prompt.append(few_shot_prompt)

    output_prompt.append("Please follow the format and describe the following actions:")
    for aid, (action, ad) in enumerate(action_ls): 
        output_prompt.append(f"{aid}. Action: {action}, Explanation: {ad}.")

    return '\n'.join(output_prompt)

if __name__ == "__main__":
    print(prompt)