#!/bin/bash

dir_path=`dirname $1` || (echo "No path provided." && exit 1)
dir_path="$dir_path"/regr/

[ ! -d "$dir_path" ] && mkdir $dir_path

for HASHES in 608 1000 2500 5000 10000; do
       	for SEED in {1..10}; do
		echo "$HASHES: $SEED"
		python ./io_model/scripts/run_performance_prediction.py  "$1" \
			--n_hashes $HASHES \
			--save_dir $dir_path \
			--use_train \
			--seed $SEED \
			--regr_name rf_tune \
			--train_dataset ./io_model/data/train_long.pt \
		        --nb_dataset ./io_model/data/nb_dataset.json
	done
done
