function plots
hold off
d=10; % small support
D=1000; % large support
p=1-1/20;
%p=1/2;
%p=1;

% wu-yang
k=d+D; % alphabet size

for n=10:5:500
    %if n<k
    %    lb = 2*(1-1/k)^(2*n);
    %else
    %    lb = k/4/n*(1-1/k);
    %end
    wy = k/n+log(n)/sqrt(n);
    plot(n,wy,'ob');
    hold on
    ub = CKKW(n,d,D,p);
    plot(n,ub,'xr');
    ct = CT(n,d,D,p);
    plot(n,ct,'.g');
    drawnow
end
title('Comparing our upper bound to the state of the art')
xlabel('$n$ = sample size','fontsize',14,'interpreter','latex')
ylabel('$\mathrm{E}|\mathrm{H}(\hat\mu_n)-\mathrm{H}(\mu)|$','fontsize',14,'interpreter','latex')
legend('Wu-Yang upper bound','Our upper bond','Cover-Thomas upper bound')
%legend('Wu-Yang lower bound','CKKW upper bond','Location','NorthEast')
return


function ub = CKKW(n,d,D,p)
% We're assuming the empirical bound only "knows" the support size d+D, but
% not p; so the alpha-moment bound is log(d+D)^alpha.
%Lambda = 1-p + sqrt(d*p/n)/2;
mu = [ones(d,1)/d*p;ones(D,1)/D*(1-p)];
ii = find(mu<1/n); jj = find(mu>=1/n);
Lambda = 2*sum(mu(ii)) + 1/sqrt(n)*sum(sqrt(mu(jj)));
%aa=linspace(1,d+D,100);
aa=linspace(1,d+D,1000);
% choose the best alpha for this n
[ub,ai] = min((aa.^aa*(2+exp(-1))+2*(max(aa,log(d+D)).^aa+(aa./exp(1)).^aa)).^(1./aa).*Lambda.^(1-1./aa));
%fprintf('%1.5f\n',aa(ai));
return


function ub = CT(n,d,D,p)
% Cover-Thomas bound
% We're assuming the empirical bound only "knows" the support size d+D, but
% not p; so the alpha-moment bound is log(d+D)^alpha.
%Lambda = 1-p + sqrt(d*p/n)/2;
mu = [ones(d,1)/d*p;ones(D,1)/D*(1-p)];
ii = find(mu<1/n); jj = find(mu>=1/n);
Lambda = 2*sum(mu(ii)) + 1/sqrt(n)*sum(sqrt(mu(jj)));
ub = Lambda*log((d+D)/Lambda);
return