# EfRLFN real-time Super-Resolution

This repository contains the implementation and inference code for EfRLFN, a deep learning model for single image super-resolution.

## Features
- Efficient residual architecture for high-quality image upscaling
- Supports multiple upscaling factors
- Fast inference on CUDA-enabled GPUs

## Installation
```bash
pip install -r requirements.txt
```

## Usage
### Inference

To upscale an image using a trained model:
```bash
python inference.py -w [WEIGHTS_PATH] -s [SCALE_FACTOR] -i [INPUT_IMAGE] -o [OUTPUT_IMAGE]
```
### Arguments:

    -w/--weights: Path to the pretrained model weights (.pt or .ckpt format)

    -s/--scale: Upscaling factor (e.g., 2, 4)

    -i/--input: Path to input image

    -o/--output: Path to save the output image

### Example
```bash
python inference.py -w weights/EfRLFN-4x-model.ph -s 4 -i images/low_res.jpg -o images/high_res.jpg
```
## Model Weights

Pretrained weights are available for different scale factors:

[EfRLFN x2](https://drive.google.com/file/d/1LLwOZlgnfzFE_hTHIrbleGjoZ8upzyAl/view?usp=sharing)

[EfRLFN x4](https://drive.google.com/file/d/1CKF0yYt7g_i7aC_I63KoTi9YcfDXJplg/view?usp=sharing)

## Dataset
A sample of the proposed dataset can be downloaded here:
[Dataset sample](https://drive.google.com/file/d/1XX1TbCMMvyTHFtvPGyblljzSTuopGE5t/view?usp=sharing)

Test set with subjective scores for each method can be downloaded here:
[Dataset with subjective scores](https://drive.google.com/file/d/1D9uYS78jCZA33OTppMQZIF6zH6QIdPpF/view?usp=sharing)