from lfrl.core.rl_algorithms.torch_rl_algorithm import TorchOfflineRLAlgorithm


def get_offline_algorithm(config, eval_path_collector):

    algorithm = TorchOfflineRLAlgorithm(
        trainer=config['trainer'],
        evaluation_policy=config['evaluation_policy'],
        evaluation_env=config['evaluation_env'],
        replay_buffer=config['replay_buffer'],
        evaluation_data_collector=eval_path_collector,
        **config['offline_kwargs']
    )

    return algorithm


def get_config(
        variant,
        expl_env,
        eval_env,
        obs_dim,
        action_dim,
        replay_buffer,
):
    raise NotImplementedError('must implement get_config')
