import gym
# import gym_minigrid

from lfrl.envs.wrappers import NormalizedBoxEnv, NonTerminatingEnv, SwapColorEnv


gym.logger.set_level(40)  # stop annoying Box bound precision error


def make_env(env_name, terminates=True, **kwargs):
    env = None
    base_env = None
    env_infos = dict()

    """
    Episodic reinforcement learning
    """
    if env_name == 'HalfCheetah':
        from gym.envs.mujoco import HalfCheetahEnv
        base_env = HalfCheetahEnv
        env_infos['mujoco'] = True
    elif env_name == 'Hopper':
        from gym.envs.mujoco import HopperEnv
        base_env = HopperEnv
        env_infos['mujoco'] = True
    elif env_name == 'InvertedPendulum':
        from gym.envs.mujoco import InvertedPendulumEnv
        base_env = InvertedPendulumEnv
        env_infos['mujoco'] = True
    elif env_name == 'Cartpole':
        from lfrl.envs.environments.cartpole import CartpoleEnv
        base_env = CartpoleEnv
        env_infos['mujoco'] = True
    elif env_name == 'Pendulum':
        from gym.envs.classic_control.pendulum import PendulumEnv
        base_env = PendulumEnv
        env_infos['mujoco'] = False

    """
    Lifelong reinforcement learning
    """
    if env_name == 'ContinualHopper':
        from lfrl.envs.environments.hopper_env import ContinualHopperEnv
        base_env = ContinualHopperEnv
        env_infos['mujoco'] = True
    elif env_name == 'ContinualAnt':
        from lfrl.envs.environments.ant_env import ContinualAntEnv
        base_env = ContinualAntEnv
        env_infos['mujoco'] = True
    elif env_name == 'Gridworld':
        from lfrl.envs.environments.continuous_gridworld.cont_gridworld import ContinuousGridworld
        base_env = ContinuousGridworld
        env_infos['mujoco'] = False
    
    if env is None and base_env is None:
        raise NameError('env_name not recognized')

    if env is None:
        env = base_env(**kwargs)

    if not isinstance(env.action_space, gym.spaces.Discrete):
        env = NormalizedBoxEnv(env)

    if not terminates:
        env = NonTerminatingEnv(env)

    return env, env_infos
