from lfrl.core.rl_algorithms.torch_rl_algorithm import TorchMBRLAlgorithm


def get_algorithm(config, expl_path_collector, eval_path_collector):

    algorithm = TorchMBRLAlgorithm(
        trainer=config['trainer'],
        exploration_policy=config['exploration_policy'],
        model_trainer=config['model_trainer'],
        exploration_env=config['exploration_env'],
        evaluation_env=config['evaluation_env'],
        replay_buffer=config['replay_buffer'],
        exploration_data_collector=expl_path_collector,
        evaluation_data_collector=eval_path_collector,
        **config['algorithm_kwargs']
    )

    return algorithm


def get_config(
        variant,
        expl_env,
        eval_env,
        obs_dim,
        action_dim,
        replay_buffer,
):
    raise NotImplementedError('must implement get_config')
