## AutoML.cc - Supplemental Material for Automated Super-Network Generation for Scalable Neural Architecture Search

## System requirements
- Ubuntu\* 18.04 or later (64-bit)
- Python\* 3.6.2 or later
- Supported frameworks:
  - PyTorch\* >=1.5.0, <=1.9.1 (1.8.0 not supported)
  - TensorFlow\* >=2.4.0, <=2.5.3

This code has been tested on Python* 3.6.2+, PyTorch* 1.9.1 (NVidia CUDA\* Toolkit 10.2) and TensorFlow* 2.5.3 (NVidia CUDA\* Toolkit 11.2).

## Running the scripts and notebooks

1. Install the requirements with ```pip install -r requirements.txt```. 
2. **NNCF's pip package that contains BootstrapNAS will be released around April 15**. Currently, pip will install NNCF version 2.1.0, which does NOT support BootstrapNAS. To install the latest BootstrapNAS code use the following: ```pip install nncf-dev-py3-none-any.whl``` 

3. To run the super-network generation and sub-network search use the ```nas_advanced_main.py``` script from the ```scripts_and_notebooks``` folder: 

```
python nas_advanced_main.py -m train -c ../config/config.json --data <path to your CIFAR10 dataset> --weights <path to weights for resnet-50 trained with CIFAR10>
```

Weights for CIFAR10-based models can be found at: https://github.com/huyvnphan/PyTorch_CIFAR10 

Weights for Imagenet-based models can be downloaded from [Torchvision](https://pytorch.org/vision/stable/index.html)

4. The file ```config.json``` contains a sample configuration for generating a super-network from a trained model. The sample file is configured to generate a super-network from ResNet-50 trained with CIFAR-10. The file should be modified depending on the model to be used as input for BootstrapNAS. (Please see the Appendix for more information about configuration files)

5. The repository also contains a few notebooks and csv files with the results of the experiments conducted for the paper.  

The notebook ```latency_predictor.ipynb``` contains scripts related to performance predictors. 

The notebook ```search_and_predict_examples.ipynb``` contains additional scripts related to search tests. 

**Data** 

The ````data```` folder contains several files with measurements obtained during the experiments shown in the paper. 

## License 

BootstrapNAS will be released as part of NNCF, which is licensed under the Apache License 2.0.

BootstrapNAS uses Pymoo for its search component, which is licensed under the Apache License 2.0, as well. 

**Please refer to the Appendix for more details**