import copy
from train import run_experiment


def main():
    # Base config from your JSON, with any needed modifications
    base_config = {
        "task": "A5",
        "model_name": "lcde",
        "model_dim": 1024,
        "batch_size": 256,
        "num_steps": 100000,
        "print_steps": 10000,
        "learning_rate": 0.001,
        "dropout_rate": 0.1,
        "early_stop_threshold": 0.9,
        "diagonal": True,
        "fwht": False,
        "block_size": 1,
    }

    # We begin with length=3, depth=1
    length = 3
    depth = 1

    # Continue until length > 20 or depth > 4
    while length <= 20 and depth <= 4:
        # Make a fresh config each time:
        config = copy.deepcopy(base_config)

        # Override length and depth:
        config["length"] = length
        config["num_blocks"] = depth

        print(f"\n=== Starting experiment with length={length}, depth={depth} ===")
        _, steps, val_accs, early_stop = run_experiment(config)

        # If early stop was triggered, move on to the next length
        # Otherwise, move on to the next depth
        if early_stop:
            print(f"Early stopping triggered at length={length}, depth={depth} "
                  f"(accuracy>{config['early_stop_threshold']}). Moving to length={length + 1}.")
            length += 1
        else:
            print(f"No early stopping for length={length}, depth={depth}. Moving to depth={depth + 1}.")
            depth += 1

    # When the loop finishes, we either ran out of lengths (>20) or depths (>4).
    print("\n=== Finished all runs (either length>20 or depth>4). ===")


if __name__ == "__main__":
    main()
