# PD-DP Algorithm

## Running the simulations
To run the simulations included in the paper, run:

```
./run_simulations.sh
```

This requires Tmux. If you don’t have it installed, you can install it with:
```
brew install tmux
```

In run_simulations.sh, you can modify the config_dir parameter to switch between simulations using parameters from cluster 0 flights or cluster 1 flights by selecting either config/master_config_c0 or config/master_config_c1.

You can also run a single simulation instance using:
```
python /path/to/main_data.py /path/to/sim_config_file

# example
python main_data.py config/master_config_c0/sim_config_0.json
```

## Code structure
### Config folder
This folder contains all the parameters used in the simulations:
- env_config_*.json: these files set up the MDP using real-world data.
- sim_config_*.json: these files specify the hyperparameters for a simulation, including the path to the corresponding env_config file that initializes the MDP environment.


### Core folder
Contains the implementation of the basic classes and methods used to represent 
the algorithms, the mathematical objects and the updates applied to the objects.

### Output
This is where the simulation’s output data and plots are automatically saved.

### Simulations
This folder holds the child classes that extend those in the core folder. These classes include additional methods to simulate the MDP using data generated from the config files parameters.